/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.alg.feature.detect.quadblob.QuadBlob;
import georegression.metric.UtilAngle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class OrderChessboardQuadBlobs {
    int numCols;
    int numRows;
    List<QuadBlob> results = new ArrayList<QuadBlob>();
    List<QuadBlob> top = new ArrayList<QuadBlob>();
    List<QuadBlob> bottom = new ArrayList<QuadBlob>();
    int expectedFirst;
    int expectedSecond;

    public OrderChessboardQuadBlobs(int numCols, int numRows) {
        if (numCols < 2 || numRows < 2) {
            throw new IllegalArgumentException("A valid chessboard needs to have at least 2 rows or columns");
        }
        this.numCols = numCols;
        this.numRows = numRows;
        this.expectedFirst = numCols / 2 + numCols % 2;
        this.expectedSecond = numCols / 2;
    }

    public boolean order(List<QuadBlob> blobs) {
        this.results.clear();
        this.top.clear();
        this.bottom.clear();
        QuadBlob first = null;
        double firstDistance = 0.0;
        for (QuadBlob b : blobs) {
            if (b.conn.size() != 1) continue;
            if (this.findFirstTwoRows(b)) {
                if (first != null) {
                    double d = Math.sqrt(b.center.x * b.center.x + b.center.y * b.center.y) + (double)b.center.y;
                    if (d < firstDistance) {
                        first = b;
                        firstDistance = d;
                    }
                } else {
                    firstDistance = Math.sqrt(b.center.x * b.center.x + b.center.y * b.center.y) + (double)b.center.y;
                    first = b;
                }
            }
            this.top.clear();
            this.bottom.clear();
        }
        if (first == null) {
            return false;
        }
        this.findFirstTwoRows(first);
        this.results.addAll(this.top);
        this.results.addAll(this.bottom);
        boolean useFirst = true;
        while (true) {
            QuadBlob seed;
            QuadBlob pivot = this.bottom.get(0);
            QuadBlob quadBlob = seed = useFirst ? OrderChessboardQuadBlobs.findBestCW(first, pivot) : OrderChessboardQuadBlobs.findBestCCW(first, pivot);
            if (seed == null) break;
            if (useFirst ? !this.findNextRowDown(seed, pivot, this.expectedFirst) : !this.findNextRowDown2(seed, pivot, this.expectedSecond)) {
                return false;
            }
            this.results.addAll(this.bottom);
            useFirst = !useFirst;
            first = pivot;
        }
        return blobs.size() == this.results.size();
    }

    private boolean findFirstTwoRows(QuadBlob seed) {
        QuadBlob t;
        this.top.clear();
        this.bottom.clear();
        QuadBlob c = seed.conn.get(0);
        this.top.add(seed);
        this.bottom.add(c);
        while ((t = OrderChessboardQuadBlobs.findBestCCW(seed, c)) != null) {
            this.top.add(t);
            QuadBlob b = OrderChessboardQuadBlobs.findBestCW(c, t);
            if (b == null) break;
            this.bottom.add(b);
            seed = t;
            c = b;
            if (this.top.size() <= this.expectedFirst) continue;
            return false;
        }
        return this.top.size() == this.expectedFirst && this.bottom.size() == this.expectedSecond;
    }

    private boolean findNextRowDown(QuadBlob seed, QuadBlob parent, int expected) {
        QuadBlob b;
        this.bottom.clear();
        this.bottom.add(seed);
        QuadBlob d = seed;
        QuadBlob c = parent;
        while ((b = OrderChessboardQuadBlobs.findBestCW(d, c)) != null) {
            this.bottom.add(b);
            QuadBlob t = OrderChessboardQuadBlobs.findBestCCW(c, b);
            if (t == null) break;
            c = t;
            d = b;
            if (this.bottom.size() <= expected) continue;
            return false;
        }
        return this.bottom.size() == expected;
    }

    private boolean findNextRowDown2(QuadBlob seed, QuadBlob parent, int expected) {
        QuadBlob b;
        QuadBlob t;
        this.bottom.clear();
        this.bottom.add(seed);
        QuadBlob d = parent;
        QuadBlob c = seed;
        while ((t = OrderChessboardQuadBlobs.findBestCCW(d, c)) != null && (b = OrderChessboardQuadBlobs.findBestCW(c, t)) != null) {
            this.bottom.add(b);
            c = b;
            d = t;
            if (this.bottom.size() <= expected) continue;
            return false;
        }
        return this.bottom.size() == expected;
    }

    protected static QuadBlob findBestCW(QuadBlob parent, QuadBlob pivot) {
        int bestIndex = -1;
        double bestAngle = Double.MAX_VALUE;
        double angle0 = Math.atan2(parent.center.y - pivot.center.y, parent.center.x - pivot.center.x);
        for (int i = 0; i < pivot.conn.size(); ++i) {
            double angle1;
            double cw;
            QuadBlob d = pivot.conn.get(i);
            if (d == parent || !((cw = UtilAngle.distanceCW((double)angle0, (double)(angle1 = Math.atan2(d.center.y - pivot.center.y, d.center.x - pivot.center.x)))) < bestAngle)) continue;
            bestAngle = cw;
            bestIndex = i;
        }
        if (bestAngle > 2.356194490192345 || bestIndex < 0) {
            return null;
        }
        return pivot.conn.get(bestIndex);
    }

    protected static QuadBlob findBestCCW(QuadBlob parent, QuadBlob pivot) {
        int bestIndex = -1;
        double bestAngle = Double.MAX_VALUE;
        double angle0 = Math.atan2(parent.center.y - pivot.center.y, parent.center.x - pivot.center.x);
        for (int i = 0; i < pivot.conn.size(); ++i) {
            double angle1;
            double cw;
            QuadBlob d = pivot.conn.get(i);
            if (d == parent || !((cw = UtilAngle.distanceCCW((double)angle0, (double)(angle1 = Math.atan2(d.center.y - pivot.center.y, d.center.x - pivot.center.x)))) < bestAngle)) continue;
            bestAngle = cw;
            bestIndex = i;
        }
        if (bestAngle > 2.356194490192345 || bestIndex < 0) {
            return null;
        }
        return pivot.conn.get(bestIndex);
    }

    public List<QuadBlob> getResults() {
        return this.results;
    }

    public static class ComparatorQuads
    implements Comparator<QuadBlob> {
        @Override
        public int compare(QuadBlob o1, QuadBlob o2) {
            if (o1.index < o2.index) {
                return -1;
            }
            if (o1.index == o2.index) {
                return 0;
            }
            return 1;
        }
    }
}

