/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.grid.IntensityHistogram;
import java.util.ArrayList;
import java.util.Collections;

public class HistogramTwoPeaks {
    public double peakLow;
    public double peakHigh;
    public int minSeparation;

    public HistogramTwoPeaks(int minSeparation) {
        this.minSeparation = minSeparation;
    }

    public void computePeaks(IntensityHistogram h) {
        int i;
        ArrayList<Data> peaks = new ArrayList<Data>();
        int N = h.histogram.length;
        if (h.histogram[0] > h.histogram[1]) {
            peaks.add(new Data(0, h.histogram[0]));
        }
        if (h.histogram[N - 1] > h.histogram[N - 2]) {
            peaks.add(new Data(N - 1, h.histogram[N - 1]));
        }
        for (i = 1; i < N - 1; ++i) {
            int response = 2 * h.histogram[i] - h.histogram[i - 1] - h.histogram[i + 1];
            if (response <= 0) continue;
            peaks.add(new Data(i, h.histogram[i]));
        }
        for (i = 1; i < N; ++i) {
            if (h.histogram[i] != h.histogram[i - 1]) continue;
            boolean allGood = true;
            if (i > 1) {
                boolean bl = allGood = h.histogram[i] >= h.histogram[i - 2];
            }
            if (allGood) {
                for (int j = i + 1; j < N; ++j) {
                    if (h.histogram[i] < h.histogram[j]) {
                        allGood = false;
                        break;
                    }
                    if (h.histogram[i] > h.histogram[j]) break;
                }
            }
            if (!allGood) continue;
            peaks.add(new Data(i, h.histogram[i]));
        }
        Collections.sort(peaks);
        Data b = null;
        Data a = (Data)peaks.get(0);
        for (int i2 = 1; i2 < peaks.size(); ++i2) {
            b = (Data)peaks.get(i2);
            if (Math.abs(a.index - b.index) >= this.minSeparation) break;
        }
        if (a.index < b.index) {
            this.peakLow = (double)a.index * h.divisor + h.divisor / 2.0;
            this.peakHigh = (double)b.index * h.divisor + h.divisor / 2.0;
        } else {
            this.peakLow = (double)b.index * h.divisor + h.divisor / 2.0;
            this.peakHigh = (double)a.index * h.divisor + h.divisor / 2.0;
        }
    }

    private static class Data
    implements Comparable<Data> {
        int index;
        int count;

        private Data(int index, int count) {
            this.index = index;
            this.count = count;
        }

        @Override
        public int compareTo(Data o) {
            if (o.count > this.count) {
                return 1;
            }
            if (o.count < this.count) {
                return -1;
            }
            return 0;
        }
    }
}

