/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.calib;

import boofcv.abst.calib.ConfigChessboard;
import boofcv.abst.calib.ConfigSquareGrid;
import boofcv.abst.calib.PlanarCalibrationDetector;
import boofcv.abst.calib.WrapPlanarChessTarget;
import boofcv.abst.calib.WrapPlanarSquareGridTarget;
import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;

public class FactoryPlanarCalibrationTarget {
    public static PlanarCalibrationDetector detectorSquareGrid(ConfigSquareGrid config) {
        config.checkValidity();
        return new WrapPlanarSquareGridTarget(config);
    }

    public static PlanarCalibrationDetector detectorChessboard(ConfigChessboard config) {
        config.checkValidity();
        return new WrapPlanarChessTarget(config);
    }

    public static PlanarCalibrationTarget gridSquare(int numCols, int numRows, double squareWidth, double spaceWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        numCols = numCols / 2 + 1;
        numRows = numRows / 2 + 1;
        double startX = -((double)numCols * squareWidth + (double)(numCols - 1) * spaceWidth) / 2.0;
        double startY = -((double)numRows * squareWidth + (double)(numRows - 1) * spaceWidth) / 2.0;
        for (int i = 0; i < numRows; ++i) {
            double y = startY + (double)i * (squareWidth + spaceWidth);
            ArrayList<Point2D_F64> top = new ArrayList<Point2D_F64>();
            ArrayList<Point2D_F64> bottom = new ArrayList<Point2D_F64>();
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * (squareWidth + spaceWidth);
                top.add(new Point2D_F64(x, y));
                top.add(new Point2D_F64(x + squareWidth, y));
                bottom.add(new Point2D_F64(x, y + squareWidth));
                bottom.add(new Point2D_F64(x + squareWidth, y + squareWidth));
            }
            all.addAll(top);
            all.addAll(bottom);
        }
        return new PlanarCalibrationTarget(all);
    }

    public static PlanarCalibrationTarget gridChess(int numCols, int numRows, double squareWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        double startX = -((double)(--numCols - 1) * squareWidth) / 2.0;
        double startY = -((double)(--numRows - 1) * squareWidth) / 2.0;
        for (int i = 0; i < numRows; ++i) {
            double y = startY + (double)i * squareWidth;
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * squareWidth;
                all.add(new Point2D_F64(x, y));
            }
        }
        return new PlanarCalibrationTarget(all);
    }
}

