/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.grid.IntensityHistogram;

public class FitGaussianPrune {
    private int maxIterations;
    private double thresholdSigma;
    private double mean;
    private double sigma;
    private IntensityHistogram h;
    protected int indexLow;
    protected int indexHigh;
    int minSeparation = 1;

    public FitGaussianPrune(int maxIterations, double thresholdSigma, int minSeparation) {
        this.maxIterations = maxIterations;
        this.thresholdSigma = thresholdSigma;
        this.minSeparation = minSeparation;
    }

    public void process(IntensityHistogram h, int low, int high) {
        this.h = h;
        this.indexLow = low;
        this.indexHigh = high;
        for (int i = 0; i < this.maxIterations; ++i) {
            this.updateStatistics();
            if (this.sigma == 0.0 || !this.prune()) break;
        }
        this.mean = this.mean * h.divisor + h.divisor / 2.0;
        this.sigma *= h.divisor;
    }

    private void updateStatistics() {
        int i;
        int total = 0;
        this.mean = 0.0;
        for (i = this.indexLow; i < this.indexHigh; ++i) {
            total += this.h.histogram[i];
            this.mean += (double)(i * this.h.histogram[i]);
        }
        this.mean /= (double)total;
        this.sigma = 0.0;
        for (i = this.indexLow; i < this.indexHigh; ++i) {
            double dx = (double)i - this.mean;
            this.sigma += (double)this.h.histogram[i] * dx * dx;
        }
        this.sigma = Math.sqrt(this.sigma / (double)total);
    }

    private boolean prune() {
        double diff;
        boolean change = false;
        while (Math.abs(this.mean - (double)this.indexLow) / this.sigma > this.thresholdSigma && (diff = Math.abs(this.mean - (double)this.indexLow)) > this.sigma * this.thresholdSigma && diff >= (double)this.minSeparation) {
            change = true;
            ++this.indexLow;
        }
        while ((diff = Math.abs(this.mean - (double)this.indexHigh)) > this.sigma * this.thresholdSigma && diff >= (double)this.minSeparation) {
            change = true;
            --this.indexHigh;
        }
        return change;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSigma() {
        return this.sigma;
    }
}

