/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.misc.GImageStatistics;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.sorting.QuickSort_F64;

public class UtilCalibrationGrid {
    public static int selectThreshold(ImageSingleBand image, int[] histogram) {
        GImageStatistics.histogram((ImageSingleBand)image, (int)0, (int[])histogram);
        int mean = 0;
        for (int i = 1; i < histogram.length; ++i) {
            mean += i * histogram[i];
        }
        int lower = UtilCalibrationGrid.selectMiddle(histogram, 0, mean /= image.width * image.height);
        int upper = UtilCalibrationGrid.selectMiddle(histogram, mean, histogram.length);
        return (lower + upper) / 2;
    }

    private static int selectMiddle(int[] histogram, int begin, int end) {
        int target = 0;
        for (int i = begin; i < end; ++i) {
            target += histogram[i];
        }
        target /= 2;
        int sum = 0;
        for (int i = begin; i < end; ++i) {
            if ((sum += histogram[i]) < target) continue;
            return i;
        }
        return end - 1;
    }

    private static int firstNotZero(int[] counts, int[] indexes) {
        for (int i = 0; i < counts.length; ++i) {
            if (counts[indexes[i]] == 0) continue;
            return i;
        }
        return counts.length;
    }

    public static List<Point2D_F64> rotatePoints(List<Point2D_F64> points, int numRows, int numCols, int expectedRows, int expectedCols) {
        if (expectedCols == numCols && expectedRows == numRows) {
            return points;
        }
        if (expectedCols == numRows && expectedRows == numCols) {
            return UtilCalibrationGrid.rotatePoints(points, numRows, numCols);
        }
        return null;
    }

    public static List<Point2D_F64> rotatePoints(List<Point2D_F64> points, int numRows, int numCols) {
        ArrayList<Point2D_F64> out = new ArrayList<Point2D_F64>();
        for (int i = 0; i < numCols; ++i) {
            for (int j = 0; j < numRows; ++j) {
                int index = j * numCols + (numCols - i - 1);
                out.add(points.get(index));
            }
        }
        return out;
    }

    public static int incrementCircle(int i, int dir, int size) {
        if ((i += dir) < 0) {
            i = size + i;
        } else if (i >= size) {
            i -= size;
        }
        return i;
    }

    public static int distanceCircle(int i0, int i1, int dir, int size) {
        int distance;
        int n = distance = dir > 0 ? i1 - i0 : i0 - i1;
        if (distance < 0) {
            distance = size + distance;
        }
        return distance;
    }

    public static int distanceCircle(int i0, int i1, int size) {
        int distanceA = UtilCalibrationGrid.distanceCircle(i0, i1, 1, size);
        int distanceB = UtilCalibrationGrid.distanceCircle(i0, i1, -1, size);
        return Math.min(distanceA, distanceB);
    }

    public static Point2D_I32 findAverage(List<Point2D_I32> contour) {
        int x = 0;
        int y = 0;
        for (Point2D_I32 p : contour) {
            x += p.x;
            y += p.y;
        }
        return new Point2D_I32(x /= contour.size(), y /= contour.size());
    }

    public static void sortByAngleCCW(Point2D_F64 center, List<Point2D_F64> contour) {
        double[] angles = new double[contour.size()];
        int[] indexes = new int[angles.length];
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_F64 c = contour.get(i);
            double dx = c.x - center.x;
            double dy = c.y - center.y;
            angles[i] = Math.atan2(dy, dx);
        }
        QuickSort_F64 sort = new QuickSort_F64();
        sort.sort(angles, angles.length, indexes);
        ArrayList<Point2D_F64> sorted = new ArrayList<Point2D_F64>(contour.size());
        for (int i = 0; i < indexes.length; ++i) {
            sorted.add(contour.get(indexes[i]));
        }
        contour.clear();
        contour.addAll(sorted);
    }

    public static int findFarthest(Point2D_I32 a, List<Point2D_I32> contour) {
        int best = -1;
        int index = -1;
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_I32 b = contour.get(i);
            int d = a.distance2(b);
            if (d <= best) continue;
            best = d;
            index = i;
        }
        return index;
    }

    public static int findFarthest(Point2D_F64 a, List<Point2D_F64> contour) {
        double best = -1.0;
        int index = -1;
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_F64 b = contour.get(i);
            double d = a.distance2((GeoTuple2D_F64)b);
            if (!(d > best)) continue;
            best = d;
            index = i;
        }
        return index;
    }
}

