/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import boofcv.alg.geo.calibration.RadialDistortionEstimateLinear;
import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.alg.geo.calibration.Zhang99OptimizationFunction;
import boofcv.alg.geo.calibration.Zhang99Parameters;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DenseMatrix64F;

public class CalibrationPlanarGridZhang99 {
    private Zhang99ComputeTargetHomography computeHomography;
    private Zhang99CalibrationMatrixFromHomographies computeK;
    private RadialDistortionEstimateLinear computeRadial;
    private Zhang99DecomposeHomography decomposeH = new Zhang99DecomposeHomography();
    private Zhang99Parameters optimized;
    private PlanarCalibrationTarget target;
    private boolean assumeZeroSkew;
    private UnconstrainedLeastSquares optimizer;
    private Listener listener;

    public CalibrationPlanarGridZhang99(PlanarCalibrationTarget target, boolean assumeZeroSkew, int numRadialParam) {
        this.computeHomography = new Zhang99ComputeTargetHomography(target.points);
        this.computeK = new Zhang99CalibrationMatrixFromHomographies(assumeZeroSkew);
        this.computeRadial = new RadialDistortionEstimateLinear(target, numRadialParam);
        this.target = target;
        this.assumeZeroSkew = assumeZeroSkew;
        this.optimized = new Zhang99Parameters(assumeZeroSkew, numRadialParam);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean process(List<List<Point2D_F64>> observations) {
        this.optimized.setNumberOfViews(observations.size());
        Zhang99Parameters initial = this.initialParam(observations);
        if (initial == null) {
            return false;
        }
        this.status("Non-linear refinement");
        return this.optimizedParam(observations, this.target.points, initial, this.optimized, this.optimizer);
    }

    protected Zhang99Parameters initialParam(List<List<Point2D_F64>> observations) {
        this.status("Estimating Homographies");
        ArrayList<DenseMatrix64F> homographies = new ArrayList<DenseMatrix64F>();
        ArrayList<Se3_F64> motions = new ArrayList<Se3_F64>();
        for (List<Point2D_F64> obs : observations) {
            if (!this.computeHomography.computeHomography(obs)) {
                return null;
            }
            DenseMatrix64F H = this.computeHomography.getHomography();
            homographies.add(H);
        }
        this.status("Estimating Calibration Matrix");
        this.computeK.process(homographies);
        DenseMatrix64F K = this.computeK.getCalibrationMatrix();
        this.decomposeH.setCalibrationMatrix(K);
        for (DenseMatrix64F H : homographies) {
            motions.add(this.decomposeH.decompose(H));
        }
        this.status("Estimating Radial Distortion");
        this.computeRadial.process(K, homographies, observations);
        double[] distort = this.computeRadial.getParameters();
        return CalibrationPlanarGridZhang99.convertIntoZhangParam(motions, K, this.assumeZeroSkew, distort);
    }

    private void status(String message) {
        if (this.listener != null && !this.listener.zhangUpdate(message)) {
            throw new RuntimeException("User requested termination of calibration");
        }
    }

    public boolean optimizedParam(List<List<Point2D_F64>> observations, List<Point2D_F64> grid, Zhang99Parameters initial, Zhang99Parameters found, UnconstrainedLeastSquares optimizer) {
        if (optimizer == null) {
            optimizer = FactoryOptimization.leastSquaresLM((double)0.001, (boolean)true);
        }
        double[] model = new double[initial.size()];
        initial.convertToParam(model);
        Zhang99OptimizationFunction func = new Zhang99OptimizationFunction(initial.createNew(), grid, observations);
        optimizer.setFunction((FunctionNtoM)func, null);
        optimizer.initialize(model, 1.0E-10, 1.0E-25 * (double)observations.size());
        for (int i = 0; i < 500 && !optimizer.iterate(); ++i) {
            if (i % 25 != 0) continue;
            this.status("Progress " + (double)(100 * i) / 500.0 + "%");
        }
        double[] param = optimizer.getParameters();
        found.setFromParam(param);
        return true;
    }

    public static Zhang99Parameters convertIntoZhangParam(List<Se3_F64> motions, DenseMatrix64F K, boolean assumeZeroSkew, double[] distort) {
        Zhang99Parameters ret = new Zhang99Parameters();
        ret.assumeZeroSkew = assumeZeroSkew;
        ret.a = K.get(0, 0);
        ret.b = K.get(1, 1);
        ret.c = K.get(0, 1);
        ret.x0 = K.get(0, 2);
        ret.y0 = K.get(1, 2);
        ret.distortion = distort;
        ret.views = new Zhang99Parameters.View[motions.size()];
        for (int i = 0; i < ret.views.length; ++i) {
            Se3_F64 m = motions.get(i);
            Zhang99Parameters.View v = new Zhang99Parameters.View();
            v.T = m.getT();
            RotationMatrixGenerator.matrixToRodrigues((DenseMatrix64F)m.getR(), (Rodrigues_F64)v.rotation);
            ret.views[i] = v;
        }
        return ret;
    }

    public static void applyDistortion(Point2D_F64 pt, double[] radial) {
        double r2;
        double a = 0.0;
        double r = r2 = pt.x * pt.x + pt.y * pt.y;
        for (int i = 0; i < radial.length; ++i) {
            a += radial[i] * r;
            r *= r2;
        }
        pt.x += pt.x * a;
        pt.y += pt.y * a;
    }

    public void setOptimizer(UnconstrainedLeastSquares optimizer) {
        this.optimizer = optimizer;
    }

    public Zhang99Parameters getOptimized() {
        return this.optimized;
    }

    public static interface Listener {
        public boolean zhangUpdate(String var1);
    }
}

