/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.UtilVector3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class Zhang99DecomposeHomography {
    DenseMatrix64F r1 = new DenseMatrix64F(3, 1);
    DenseMatrix64F r2 = new DenseMatrix64F(3, 1);
    DenseMatrix64F t = new DenseMatrix64F(3, 1);
    DenseMatrix64F temp = new DenseMatrix64F(3, 1);
    DenseMatrix64F R = new DenseMatrix64F(3, 3);
    DenseMatrix64F K;
    DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);

    public void setCalibrationMatrix(DenseMatrix64F K) {
        this.K = K;
        CommonOps.invert((DenseMatrix64F)K, (DenseMatrix64F)this.K_inv);
    }

    public Se3_F64 decompose(DenseMatrix64F H) {
        DenseMatrix64F[] h = SpecializedOps.splitIntoVectors((RowD1Matrix64F)H, (boolean)true);
        CommonOps.mult((RowD1Matrix64F)this.K_inv, (RowD1Matrix64F)h[0], (RowD1Matrix64F)this.temp);
        double lambda = NormOps.normF((D1Matrix64F)this.temp);
        CommonOps.mult((RowD1Matrix64F)this.K_inv, (RowD1Matrix64F)h[1], (RowD1Matrix64F)this.temp);
        lambda += NormOps.normF((D1Matrix64F)this.temp);
        lambda = 2.0 / lambda;
        CommonOps.mult((double)lambda, (RowD1Matrix64F)this.K_inv, (RowD1Matrix64F)h[0], (RowD1Matrix64F)this.r1);
        CommonOps.mult((double)lambda, (RowD1Matrix64F)this.K_inv, (RowD1Matrix64F)h[1], (RowD1Matrix64F)this.r2);
        CommonOps.mult((double)lambda, (RowD1Matrix64F)this.K_inv, (RowD1Matrix64F)h[2], (RowD1Matrix64F)this.t);
        Vector3D_F64 v1 = UtilVector3D_F64.convert((DenseMatrix64F)this.r1);
        Vector3D_F64 v2 = UtilVector3D_F64.convert((DenseMatrix64F)this.r2);
        Vector3D_F64 v3 = v1.cross(v2);
        UtilVector3D_F64.createMatrix((DenseMatrix64F)this.R, (Vector3D_F64[])new Vector3D_F64[]{v1, v2, v3});
        Se3_F64 ret = new Se3_F64();
        ConvertRotation3D_F64.approximateRotationMatrix((DenseMatrix64F)this.R, (DenseMatrix64F)ret.getR());
        ret.getT().set(this.t.data[0], this.t.data[1], this.t.data[2]);
        return ret;
    }
}

