/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.h.HomographyLinear4;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class Zhang99ComputeTargetHomography {
    HomographyLinear4 linear = new HomographyLinear4(true);
    DenseMatrix64F found = new DenseMatrix64F(3, 3);
    List<Point2D_F64> worldPoints;

    public Zhang99ComputeTargetHomography(List<Point2D_F64> worldPoints) {
        this.worldPoints = worldPoints;
    }

    public boolean computeHomography(CalibrationObservation observedPoints) {
        if (observedPoints.size() < 4) {
            throw new IllegalArgumentException("At least 4 points needed in each set of observations.  Filter these first please");
        }
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int i = 0; i < observedPoints.size(); ++i) {
            int which = observedPoints.get((int)i).index;
            PointIndex2D_F64 obs = observedPoints.get(i);
            pairs.add(new AssociatedPair(this.worldPoints.get(which), (Point2D_F64)obs, true));
        }
        return this.linear.process(pairs, this.found);
    }

    public DenseMatrix64F getHomography() {
        return this.found.copy();
    }
}

