/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;

public class GeneralToInterestPoint<T extends ImageSingleBand, D extends ImageSingleBand>
extends EasyGeneralFeatureDetector<T, D>
implements InterestPointDetector<T> {
    double scale = 1.0;
    protected FastQueue<Point2D_F64> foundPoints = new FastQueue(10, Point2D_F64.class, true);

    public GeneralToInterestPoint(GeneralFeatureDetector<T, D> detector, double scale, Class<T> imageType, Class<D> derivType) {
        super(detector, imageType, derivType);
        this.scale = scale;
    }

    public GeneralToInterestPoint(GeneralFeatureDetector<T, D> detector, ImageGradient<T, D> gradient, ImageHessian<D> hessian, double scale, Class<D> derivType) {
        super(detector, gradient, hessian, derivType);
        this.scale = scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void detect(T input) {
        Point2D_I16 p;
        int i;
        QueueCorner corners;
        super.detect(input, null);
        this.foundPoints.reset();
        if (this.getDetector().isDetectMaximums()) {
            corners = this.detector.getMaximums();
            for (i = 0; i < corners.size; ++i) {
                p = (Point2D_I16)corners.get(i);
                ((Point2D_F64)this.foundPoints.grow()).set((double)p.x, (double)p.y);
            }
        }
        if (this.getDetector().isDetectMinimums()) {
            corners = this.detector.getMinimums();
            for (i = 0; i < corners.size; ++i) {
                p = (Point2D_I16)corners.get(i);
                ((Point2D_F64)this.foundPoints.grow()).set((double)p.x, (double)p.y);
            }
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.foundPoints.get(featureIndex);
    }

    @Override
    public double getScale(int featureIndex) {
        return this.scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }
}

