/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.ShiTomasiCornerIntensity;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public class ImplSsdCornerNaive<T extends ImageSingleBand>
implements ShiTomasiCornerIntensity<T> {
    private int radius;
    private Kernel2D_I32 weights;

    public ImplSsdCornerNaive(int imageWidth, int imageHeight, int windowRadius, boolean weighted) {
        this.radius = windowRadius;
        if (weighted) {
            this.weights = (Kernel2D_I32)FactoryKernelGaussian.gaussian(Kernel2D_I32.class, (double)-1.0, (int)this.radius);
        }
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getIgnoreBorder() {
        return this.radius;
    }

    @Override
    public void process(T derivX, T derivY, ImageFloat32 intensity) {
        int imgHeight = derivX.getHeight();
        int imgWidth = derivX.getWidth();
        for (int row = this.radius; row < imgHeight - this.radius; ++row) {
            for (int col = this.radius; col < imgWidth - this.radius; ++col) {
                double dxdx = 0.0;
                double dxdy = 0.0;
                double dydy = 0.0;
                double totalW = 0.0;
                for (int i = -this.radius; i <= this.radius; ++i) {
                    for (int j = -this.radius; j <= this.radius; ++j) {
                        double dx = GeneralizedImageOps.get(derivX, (int)(col + j), (int)(row + i));
                        double dy = GeneralizedImageOps.get(derivY, (int)(col + j), (int)(row + i));
                        double w = 1.0;
                        if (this.weights != null) {
                            w = this.weights.get(j + this.radius, i + this.radius);
                        }
                        dxdx += w * dx * dx;
                        dydy += w * dy * dy;
                        dxdy += w * dx * dy;
                        totalW += w;
                    }
                }
                if (this.weights != null) {
                    dxdx /= totalW;
                    dydy /= totalW;
                    dxdy /= totalW;
                }
                double left = (dxdx + dydy) * 0.5;
                double b = (dxdx - dydy) * 0.5;
                double right = Math.sqrt(b * b + dxdy * dxdy);
                intensity.set(col, row, (float)(left - right));
            }
        }
    }
}

