/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.CachedSineCosine_F32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F32;

public class HoughTransformLinePolar {
    NonMaxSuppression extractor;
    FastQueue<LineParametric2D_F32> lines = new FastQueue(10, LineParametric2D_F32.class, true);
    int originX;
    int originY;
    double r_max;
    ImageFloat32 transform = new ImageFloat32(1, 1);
    QueueCorner foundLines = new QueueCorner(10);
    GrowQueue_F32 foundIntensity = new GrowQueue_F32(10);
    CachedSineCosine_F32 tableTrig;

    public HoughTransformLinePolar(NonMaxSuppression extractor, int numBinsRange, int numBinsAngle) {
        if (!extractor.canDetectBorder()) {
            throw new IllegalArgumentException("The extractor must also process the image border");
        }
        this.extractor = extractor;
        this.transform.reshape(numBinsRange, numBinsAngle);
        this.tableTrig = new CachedSineCosine_F32(0.0f, (float)Math.PI, numBinsAngle);
    }

    public int getNumBinsRange() {
        return this.transform.getWidth();
    }

    public int getNumBinsAngle() {
        return this.transform.getHeight();
    }

    public void transform(ImageUInt8 binary) {
        ImageMiscOps.fill((ImageFloat32)this.transform, (float)0.0f);
        this.originX = binary.width / 2;
        this.originY = binary.height / 2;
        this.r_max = Math.sqrt(this.originX * this.originX + this.originY * this.originY);
        for (int y = 0; y < binary.height; ++y) {
            int start = binary.startIndex + y * binary.stride;
            int stop = start + binary.width;
            for (int index = start; index < stop; ++index) {
                if (binary.data[index] == 0) continue;
                this.parameterize(index - start, y);
            }
        }
    }

    public FastQueue<LineParametric2D_F32> extractLines() {
        this.lines.reset();
        this.foundLines.reset();
        this.foundIntensity.reset();
        this.extractor.process(this.transform, null, null, null, this.foundLines);
        int w2 = this.transform.width / 2;
        for (int i = 0; i < this.foundLines.size(); ++i) {
            Point2D_I16 p = (Point2D_I16)this.foundLines.get(i);
            float r = (float)(this.r_max * (double)(p.x - w2) / (double)w2);
            float c = this.tableTrig.c[p.y];
            float s = this.tableTrig.s[p.y];
            float x0 = r * c + (float)this.originX;
            float y0 = r * s + (float)this.originY;
            this.foundIntensity.push(this.transform.get((int)p.x, (int)p.y));
            LineParametric2D_F32 l = (LineParametric2D_F32)this.lines.grow();
            l.p.set(x0, y0);
            l.slope.set(-s, c);
        }
        return this.lines;
    }

    public void parameterize(int x, int y) {
        x -= this.originX;
        y -= this.originY;
        int w2 = this.transform.width / 2;
        for (int i = 0; i < this.transform.height; ++i) {
            int index;
            double p = (float)x * this.tableTrig.c[i] + (float)y * this.tableTrig.s[i];
            int col = (int)Math.floor(p * (double)w2 / this.r_max) + w2;
            int n = index = this.transform.startIndex + i * this.transform.stride + col;
            this.transform.data[n] = this.transform.data[n] + 1.0f;
        }
    }

    public ImageFloat32 getTransform() {
        return this.transform;
    }

    public float[] getFoundIntensity() {
        return this.foundIntensity.data;
    }
}

