/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationHistogram;
import boofcv.struct.image.ImageSInt16;

public class ImplOrientationHistogram_S16
extends OrientationHistogram<ImageSInt16> {
    public ImplOrientationHistogram_S16(int numAngles, boolean isWeighted) {
        super(numAngles, isWeighted);
    }

    @Override
    public Class<ImageSInt16> getImageType() {
        return ImageSInt16.class;
    }

    @Override
    protected void computeUnweightedScore() {
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((ImageSInt16)this.derivX).startIndex + ((ImageSInt16)this.derivX).stride * y + this.rect.x0;
            int indexY = ((ImageSInt16)this.derivY).startIndex + ((ImageSInt16)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int discreteAngle;
                short dx = ((ImageSInt16)this.derivX).data[indexX];
                short dy = ((ImageSInt16)this.derivY).data[indexY];
                double angle = Math.atan2(dy, dx);
                int n = discreteAngle = (int)((angle + this.angleRound) / this.angleDiv) % this.numAngles;
                this.sumDerivX[n] = this.sumDerivX[n] + (double)dx;
                int n2 = discreteAngle;
                this.sumDerivY[n2] = this.sumDerivY[n2] + (double)dy;
                ++x;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected void computeWeightedScore(int c_x, int c_y) {
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((ImageSInt16)this.derivX).startIndex + ((ImageSInt16)this.derivX).stride * y + this.rect.x0;
            int indexY = ((ImageSInt16)this.derivY).startIndex + ((ImageSInt16)this.derivY).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.radiusScale) * this.weights.width + this.rect.x0 - c_x + this.radiusScale;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int discreteAngle;
                float w = this.weights.data[indexW];
                short dx = ((ImageSInt16)this.derivX).data[indexX];
                short dy = ((ImageSInt16)this.derivY).data[indexY];
                double angle = Math.atan2(dy, dx);
                int n = discreteAngle = (int)((angle + this.angleRound) / this.angleDiv) % this.numAngles;
                this.sumDerivX[n] = this.sumDerivX[n] + (double)(w * (float)dx);
                int n2 = discreteAngle;
                this.sumDerivY[n2] = this.sumDerivY[n2] + (double)(w * (float)dy);
                ++x;
                ++indexX;
                ++indexY;
                ++indexW;
            }
        }
    }
}

