/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.shapes;

import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.GrowQueue_B;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class SplitMergeLineFit {
    protected int maxIterations = 100;
    protected double toleranceSplitSq;
    protected double toleranceMerge;
    protected List<Point2D_I32> contour;
    protected LineParametric2D_F64 line = new LineParametric2D_F64();
    protected Point2D_F64 point2D = new Point2D_F64();
    protected GrowQueue_I32 splits = new GrowQueue_I32();
    protected GrowQueue_I32 work = new GrowQueue_I32();
    protected GrowQueue_B changed = new GrowQueue_B();

    public SplitMergeLineFit(double toleranceSplit, double toleranceMerge, int maxIterations) {
        this.toleranceSplitSq = toleranceSplit * toleranceSplit;
        this.toleranceMerge = toleranceMerge;
        this.maxIterations = maxIterations;
    }

    public abstract void process(List<Point2D_I32> var1);

    protected double computeAcute(Point2D_I32 a, Point2D_I32 b, Point2D_I32 c) {
        int dx0 = b.x - a.x;
        int dy0 = b.y - a.y;
        int dx1 = c.x - b.x;
        int dy1 = c.y - b.y;
        int dot = dx0 * dx1 + dy0 * dy1;
        double bottom = Math.sqrt(dx0 * dx0 + dy0 * dy0) * Math.sqrt(dx1 * dx1 + dy1 * dy1);
        return Math.acos((double)dot / bottom);
    }

    public GrowQueue_I32 getSplits() {
        return this.splits;
    }
}

