/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.slic;

import boofcv.alg.segmentation.slic.SegmentSlic;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.MultiSpectral;

public class SegmentSlic_MsF32
extends SegmentSlic<MultiSpectral<ImageFloat32>> {
    public SegmentSlic_MsF32(int numberOfRegions, float m, int totalIterations, ConnectRule connectRule, int numBands) {
        super(numberOfRegions, m, totalIterations, connectRule, ImageType.ms((int)numBands, ImageFloat32.class));
    }

    @Override
    public void setColor(float[] color, int x, int y) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            color[i] = ((ImageFloat32)((MultiSpectral)this.input).getBand(i)).unsafe_get(x, y);
        }
    }

    @Override
    public void addColor(float[] color, int index, float weight) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            int n = i;
            color[n] = color[n] + ((ImageFloat32)((MultiSpectral)this.input).getBand((int)i)).data[index] * weight;
        }
    }

    @Override
    public float colorDistance(float[] color, int index) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            float diff = ((ImageFloat32)((MultiSpectral)this.input).getBand((int)i)).data[index] - color[i];
            total += diff * diff;
        }
        return total;
    }

    @Override
    public float getIntensity(int x, int y) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        int index = ((MultiSpectral)this.input).getIndex(x, y);
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            total += ((ImageFloat32)((MultiSpectral)this.input).getBand((int)i)).data[index];
        }
        return total / (float)numBands;
    }
}

