/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.flow;

import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.alg.flow.HornSchunckPyramid;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class HornSchunckPyramid_to_DenseOpticalFlow<T extends ImageGray>
implements DenseOpticalFlow<T> {
    HornSchunckPyramid<T> hornSchunck;
    Class<T> imageType;

    public HornSchunckPyramid_to_DenseOpticalFlow(HornSchunckPyramid<T> hornSchunck, Class<T> imageType) {
        this.hornSchunck = hornSchunck;
        this.imageType = imageType;
    }

    @Override
    public void process(T source, T destination, ImageFlow flow) {
        this.hornSchunck.process(source, destination);
        GrayF32 flowX = this.hornSchunck.getFlowX();
        GrayF32 flowY = this.hornSchunck.getFlowY();
        int index = 0;
        for (int y = 0; y < flow.height; ++y) {
            int x = 0;
            while (x < flow.width) {
                ImageFlow.D d = flow.unsafe_get(x, y);
                d.x = flowX.data[index];
                d.y = flowY.data[index];
                ++x;
                ++index;
            }
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.imageType);
    }
}

