/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.color;

import boofcv.alg.feature.color.HistogramFeatureOps;
import boofcv.alg.feature.color.Histogram_F64;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class GHistogramFeatureOps {
    public static <T extends ImageGray> void histogram(T image, double minPixelValue, double maxPixelValue, TupleDesc_F64 histogram) {
        if (image.getClass() == GrayU8.class) {
            HistogramFeatureOps.histogram((GrayU8)image, (int)maxPixelValue, histogram);
        } else if (image.getClass() == GrayU16.class) {
            HistogramFeatureOps.histogram((GrayU16)image, (int)maxPixelValue, histogram);
        } else if (image.getClass() == GrayF32.class) {
            HistogramFeatureOps.histogram((GrayF32)image, (float)minPixelValue, (float)maxPixelValue, histogram);
        } else {
            throw new IllegalArgumentException("Unsupported band type");
        }
    }

    public static <T extends ImageGray> void histogram(Planar<T> image, Histogram_F64 histogram) {
        if (image.getNumBands() != histogram.getDimensions()) {
            throw new IllegalArgumentException("Number of bands in the image and histogram must be the same");
        }
        if (image.getBandType() == GrayU8.class) {
            HistogramFeatureOps.histogram_U8(image, histogram);
        } else if (image.getBandType() == GrayF32.class) {
            HistogramFeatureOps.histogram_F32(image, histogram);
        } else {
            throw new IllegalArgumentException("Umage type not yet supportd");
        }
    }

    public static void histogram(double[] colors, int length, Histogram_F64 histogram) {
        if (length % histogram.getDimensions() != 0) {
            throw new IllegalArgumentException("Length does not match dimensions");
        }
        int[] coordinate = new int[histogram.getDimensions()];
        histogram.fill(0.0);
        int i = 0;
        while (i < length) {
            int index;
            int j = 0;
            while (j < coordinate.length) {
                coordinate[j] = histogram.getDimensionIndex(j, colors[i]);
                ++j;
                ++i;
            }
            int n = index = histogram.getIndex(coordinate);
            histogram.value[n] = histogram.value[n] + 1.0;
        }
    }
}

