/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.edge.impl.ImplEdgeNonMaxSuppression;
import boofcv.alg.feature.detect.edge.impl.ImplEdgeNonMaxSuppressionCrude;
import boofcv.alg.feature.detect.edge.impl.ImplGradientToEdgeFeatures;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;

public class GradientToEdgeFeatures {
    public static void intensityE(GrayF32 derivX, GrayF32 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
    }

    public static void intensityAbs(GrayF32 derivX, GrayF32 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityAbs(derivX, derivY, intensity);
    }

    public static void direction(GrayF32 derivX, GrayF32 derivY, GrayF32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction(derivX, derivY, angle);
    }

    public static void direction2(GrayF32 derivX, GrayF32 derivY, GrayF32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction2(derivX, derivY, angle);
    }

    public static void intensityE(GrayS16 derivX, GrayS16 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
    }

    public static void intensityAbs(GrayS16 derivX, GrayS16 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityAbs(derivX, derivY, intensity);
    }

    public static void direction(GrayS16 derivX, GrayS16 derivY, GrayF32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction(derivX, derivY, angle);
    }

    public static void direction2(GrayS16 derivX, GrayS16 derivY, GrayF32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction2(derivX, derivY, angle);
    }

    public static void intensityE(GrayS32 derivX, GrayS32 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
    }

    public static void intensityAbs(GrayS32 derivX, GrayS32 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityAbs(derivX, derivY, intensity);
    }

    public static void direction(GrayS32 derivX, GrayS32 derivY, GrayF32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction(derivX, derivY, angle);
    }

    public static void direction2(GrayS32 derivX, GrayS32 derivY, GrayF32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction2(derivX, derivY, angle);
    }

    public static GrayS8 discretizeDirection4(GrayF32 angle, GrayS8 discrete) {
        discrete = (GrayS8)InputSanityCheck.checkDeclare((ImageGray)angle, (ImageGray)discrete, GrayS8.class);
        float A = 0.3926991f;
        float B = 0.7853982f;
        int w = angle.width;
        int h = angle.height;
        for (int y = 0; y < h; ++y) {
            int indexSrc = angle.startIndex + y * angle.stride;
            int indexDst = discrete.startIndex + y * discrete.stride;
            int end = indexSrc + w;
            while (indexSrc < end) {
                float a = angle.data[indexSrc];
                int val = a >= 0.0f ? (int)((a + 0.3926991f) / 0.7853982f) : (int)((a - 0.3926991f) / 0.7853982f);
                discrete.data[indexDst] = (byte)(val == -2 ? 2 : val);
                ++indexSrc;
                ++indexDst;
            }
        }
        return discrete;
    }

    public static GrayS8 discretizeDirection8(GrayF32 angle, GrayS8 discrete) {
        discrete = (GrayS8)InputSanityCheck.checkDeclare((ImageGray)angle, (ImageGray)discrete, GrayS8.class);
        float A = 0.3926991f;
        float B = 0.7853982f;
        int w = angle.width;
        int h = angle.height;
        for (int y = 0; y < h; ++y) {
            int indexSrc = angle.startIndex + y * angle.stride;
            int indexDst = discrete.startIndex + y * discrete.stride;
            int end = indexSrc + w;
            while (indexSrc < end) {
                float a = angle.data[indexSrc];
                int val = a >= 0.0f ? (int)((a + 0.3926991f) / 0.7853982f) : (int)((a - 0.3926991f) / 0.7853982f);
                discrete.data[indexDst] = (byte)(val == -4 ? 4 : val);
                ++indexSrc;
                ++indexDst;
            }
        }
        return discrete;
    }

    public static GrayF32 nonMaxSuppression4(GrayF32 intensity, GrayS8 direction, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)direction);
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageGray)intensity, (ImageGray)output);
        ImplEdgeNonMaxSuppression.inner4(intensity, direction, output);
        ImplEdgeNonMaxSuppression.border4(intensity, direction, output);
        return output;
    }

    public static GrayF32 nonMaxSuppression8(GrayF32 intensity, GrayS8 direction, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)direction);
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageGray)intensity, (ImageGray)output);
        ImplEdgeNonMaxSuppression.inner8(intensity, direction, output);
        ImplEdgeNonMaxSuppression.border8(intensity, direction, output);
        return output;
    }

    public static GrayF32 nonMaxSuppressionCrude4(GrayF32 intensity, GrayF32 derivX, GrayF32 derivY, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)derivX, (ImageBase)derivY);
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageGray)intensity, (ImageGray)output);
        ImplEdgeNonMaxSuppressionCrude.inner4(intensity, derivX, derivY, output);
        ImplEdgeNonMaxSuppressionCrude.border4(intensity, derivX, derivY, output);
        return output;
    }

    public static GrayF32 nonMaxSuppressionCrude4(GrayF32 intensity, GrayS16 derivX, GrayS16 derivY, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)derivX, (ImageBase)derivY);
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageGray)intensity, (ImageGray)output);
        ImplEdgeNonMaxSuppressionCrude.inner4(intensity, derivX, derivY, output);
        ImplEdgeNonMaxSuppressionCrude.border4(intensity, (GrayI)derivX, (GrayI)derivY, output);
        return output;
    }

    public static GrayF32 nonMaxSuppressionCrude4(GrayF32 intensity, GrayS32 derivX, GrayS32 derivY, GrayF32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)derivX, (ImageBase)derivY);
        output = (GrayF32)InputSanityCheck.checkDeclare((ImageGray)intensity, (ImageGray)output);
        ImplEdgeNonMaxSuppressionCrude.inner4(intensity, derivX, derivY, output);
        ImplEdgeNonMaxSuppressionCrude.border4(intensity, (GrayI)derivX, (GrayI)derivY, output);
        return output;
    }
}

