/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import java.util.Arrays;
import org.ddogleg.struct.GrowQueue_I32;

public class ImageSegmentationOps {
    public static int countRegionPixels(GrayS32 labeled, int which) {
        int total = 0;
        for (int y = 0; y < labeled.height; ++y) {
            int index = labeled.startIndex + y * labeled.stride;
            for (int x = 0; x < labeled.width; ++x) {
                if (labeled.data[index++] != which) continue;
                ++total;
            }
        }
        return total;
    }

    public static void countRegionPixels(GrayS32 labeled, int totalRegions, int[] counts) {
        Arrays.fill(counts, 0, totalRegions, 0);
        for (int y = 0; y < labeled.height; ++y) {
            int index = labeled.startIndex + y * labeled.stride;
            for (int x = 0; x < labeled.width; ++x) {
                int n = labeled.data[index++];
                counts[n] = counts[n] + 1;
            }
        }
    }

    public static void regionPixelId_to_Compact(GrayS32 graph, GrowQueue_I32 segmentId, GrayS32 output) {
        int indexGraph;
        int i;
        InputSanityCheck.checkSameShape((ImageBase)graph, (ImageBase)output);
        for (i = 0; i < segmentId.size; ++i) {
            graph.data[segmentId.data[i]] = i;
        }
        for (int y = 0; y < output.height; ++y) {
            indexGraph = graph.startIndex + y * graph.stride;
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOut] = graph.data[graph.data[indexGraph]];
                ++x;
                ++indexGraph;
                ++indexOut;
            }
        }
        i = 0;
        while (i < segmentId.size) {
            indexGraph = segmentId.data[i] - graph.startIndex;
            int x = indexGraph % graph.stride;
            int y = indexGraph / graph.stride;
            output.data[output.startIndex + y * output.stride + x] = i++;
        }
    }

    public static void markRegionBorders(GrayS32 labeled, GrayU8 output) {
        int region1;
        int region0;
        int x;
        int indexOutput;
        int indexLabeled;
        int y;
        InputSanityCheck.checkSameShape((ImageBase)labeled, (ImageBase)output);
        ImageMiscOps.fill((GrayI8)output, (int)0);
        for (y = 0; y < output.height - 1; ++y) {
            indexLabeled = labeled.startIndex + y * labeled.stride;
            indexOutput = output.startIndex + y * output.stride;
            x = 0;
            while (x < output.width - 1) {
                region0 = labeled.data[indexLabeled];
                region1 = labeled.data[indexLabeled + 1];
                int region2 = labeled.data[indexLabeled + labeled.stride];
                if (region0 != region1) {
                    output.data[indexOutput] = 1;
                    output.data[indexOutput + 1] = 1;
                }
                if (region0 != region2) {
                    output.data[indexOutput] = 1;
                    output.data[indexOutput + output.stride] = 1;
                }
                ++x;
                ++indexLabeled;
                ++indexOutput;
            }
        }
        for (y = 0; y < output.height - 1; ++y) {
            indexLabeled = labeled.startIndex + y * labeled.stride + output.width - 1;
            indexOutput = output.startIndex + y * output.stride + output.width - 1;
            int region02 = labeled.data[indexLabeled];
            int region2 = labeled.data[indexLabeled + labeled.stride];
            if (region02 == region2) continue;
            output.data[indexOutput] = 1;
            output.data[indexOutput + output.stride] = 1;
        }
        y = output.height - 1;
        indexLabeled = labeled.startIndex + y * labeled.stride;
        indexOutput = output.startIndex + y * output.stride;
        x = 0;
        while (x < output.width - 1) {
            region0 = labeled.data[indexLabeled];
            region1 = labeled.data[indexLabeled + 1];
            if (region0 != region1) {
                output.data[indexOutput] = 1;
                output.data[indexOutput + 1] = 1;
            }
            ++x;
            ++indexLabeled;
            ++indexOutput;
        }
    }
}

