/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.disparity;

import boofcv.alg.feature.disparity.DisparityScoreSadRect;
import boofcv.alg.feature.disparity.DisparityScoreWindowFive;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.DisparitySparseScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySparseSelect;
import boofcv.alg.feature.disparity.impl.ImplDisparityScoreSadRectFive_F32;
import boofcv.alg.feature.disparity.impl.ImplDisparityScoreSadRectFive_S16;
import boofcv.alg.feature.disparity.impl.ImplDisparityScoreSadRectFive_U8;
import boofcv.alg.feature.disparity.impl.ImplDisparityScoreSadRect_F32;
import boofcv.alg.feature.disparity.impl.ImplDisparityScoreSadRect_S16;
import boofcv.alg.feature.disparity.impl.ImplDisparityScoreSadRect_U8;
import boofcv.alg.feature.disparity.impl.ImplDisparitySparseScoreSadRect_F32;
import boofcv.alg.feature.disparity.impl.ImplDisparitySparseScoreSadRect_U8;
import boofcv.alg.feature.disparity.impl.ImplSelectRectBasicWta_F32_U8;
import boofcv.alg.feature.disparity.impl.ImplSelectRectBasicWta_S32_U8;
import boofcv.alg.feature.disparity.impl.ImplSelectRectStandard_F32_U8;
import boofcv.alg.feature.disparity.impl.ImplSelectRectStandard_S32_U8;
import boofcv.alg.feature.disparity.impl.ImplSelectSparseBasicWta_F32;
import boofcv.alg.feature.disparity.impl.ImplSelectSparseBasicWta_S32;
import boofcv.alg.feature.disparity.impl.ImplSelectSparseStandardWta_F32;
import boofcv.alg.feature.disparity.impl.ImplSelectSparseStandardWta_S32;
import boofcv.alg.feature.disparity.impl.SelectRectSubpixel;
import boofcv.alg.feature.disparity.impl.SelectSparseStandardSubpixel;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryStereoDisparityAlgs {
    public static DisparitySelect<int[], GrayU8> selectDisparity_S32(int maxError, int tolR2L, double texture) {
        if (maxError < 0 && tolR2L < 0 & texture <= 0.0) {
            return new ImplSelectRectBasicWta_S32_U8();
        }
        return new ImplSelectRectStandard_S32_U8(maxError, tolR2L, texture);
    }

    public static DisparitySelect<float[], GrayU8> selectDisparity_F32(int maxError, int tolR2L, double texture) {
        if (maxError < 0 && tolR2L < 0 & texture <= 0.0) {
            return new ImplSelectRectBasicWta_F32_U8();
        }
        return new ImplSelectRectStandard_F32_U8(maxError, tolR2L, texture);
    }

    public static DisparitySelect<int[], GrayF32> selectDisparitySubpixel_S32(int maxError, int tolR2L, double texture) {
        return new SelectRectSubpixel.S32_F32(maxError, tolR2L, texture);
    }

    public static DisparitySelect<float[], GrayF32> selectDisparitySubpixel_F32(int maxError, int tolR2L, double texture) {
        return new SelectRectSubpixel.F32_F32(maxError, tolR2L, texture);
    }

    public static DisparitySparseSelect<int[]> selectDisparitySparse_S32(int maxError, double texture) {
        if (maxError < 0 && texture <= 0.0) {
            return new ImplSelectSparseBasicWta_S32();
        }
        return new ImplSelectSparseStandardWta_S32(maxError, texture);
    }

    public static DisparitySparseSelect<float[]> selectDisparitySparse_F32(int maxError, double texture) {
        if (maxError < 0 && texture <= 0.0) {
            return new ImplSelectSparseBasicWta_F32();
        }
        return new ImplSelectSparseStandardWta_F32(maxError, texture);
    }

    public static DisparitySparseSelect<int[]> selectDisparitySparseSubpixel_S32(int maxError, double texture) {
        return new SelectSparseStandardSubpixel.S32(maxError, texture);
    }

    public static DisparitySparseSelect<float[]> selectDisparitySparseSubpixel_F32(int maxError, double texture) {
        return new SelectSparseStandardSubpixel.F32(maxError, texture);
    }

    public static <T extends ImageGray> DisparityScoreSadRect<GrayU8, T> scoreDisparitySadRect_U8(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], T> computeDisparity) {
        return new ImplDisparityScoreSadRect_U8<T>(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, computeDisparity);
    }

    public static <T extends ImageGray> DisparityScoreSadRect<GrayS16, T> scoreDisparitySadRect_S16(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], T> computeDisparity) {
        return new ImplDisparityScoreSadRect_S16<T>(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, computeDisparity);
    }

    public static <T extends ImageGray> DisparityScoreSadRect<GrayF32, T> scoreDisparitySadRect_F32(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<float[], T> computeDisparity) {
        return new ImplDisparityScoreSadRect_F32<T>(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, computeDisparity);
    }

    public static <T extends ImageGray> DisparityScoreWindowFive<GrayU8, T> scoreDisparitySadRectFive_U8(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], T> computeDisparity) {
        return new ImplDisparityScoreSadRectFive_U8<T>(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, computeDisparity);
    }

    public static <T extends ImageGray> DisparityScoreWindowFive<GrayS16, T> scoreDisparitySadRectFive_S16(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], T> computeDisparity) {
        return new ImplDisparityScoreSadRectFive_S16<T>(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, computeDisparity);
    }

    public static <T extends ImageGray> DisparityScoreWindowFive<GrayF32, T> scoreDisparitySadRectFive_F32(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<float[], T> computeDisparity) {
        return new ImplDisparityScoreSadRectFive_F32<T>(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, computeDisparity);
    }

    public static DisparitySparseScoreSadRect<int[], GrayU8> scoreDisparitySparseSadRect_U8(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY) {
        return new ImplDisparitySparseScoreSadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
    }

    public static DisparitySparseScoreSadRect<float[], GrayF32> scoreDisparitySparseSadRect_F32(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY) {
        return new ImplDisparitySparseScoreSadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
    }
}

