/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.alg.feature.detect.template.BaseTemplateIntensity;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;

public abstract class TemplateNCC<T extends ImageBase>
extends BaseTemplateIntensity<T> {
    @Override
    public void process(T template) {
        this.setupTemplate(template);
        super.process(template);
    }

    public abstract void setupTemplate(T var1);

    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    public static class U8
    extends TemplateNCC<GrayU8> {
        float area;
        float templateMean;
        float templateSigma;

        @Override
        protected float evaluate(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            int imageSum = 0;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((GrayU8)this.template).height; ++y) {
                imageIndex = ((GrayU8)this.image).startIndex + (tl_y + y) * ((GrayU8)this.image).stride + tl_x;
                for (int x = 0; x < ((GrayU8)this.template).width; ++x) {
                    imageSum += ((GrayU8)this.image).data[imageIndex++] & 0xFF;
                }
            }
            imageMean = (float)imageSum / this.area;
            for (y = 0; y < ((GrayU8)this.template).height; ++y) {
                imageIndex = ((GrayU8)this.image).startIndex + (tl_y + y) * ((GrayU8)this.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.template).startIndex + y * ((GrayU8)this.template).stride;
                for (int x = 0; x < ((GrayU8)this.template).width; ++x) {
                    int templateVal = ((GrayU8)this.template).data[templateIndex++] & 0xFF;
                    float diff = (float)(((GrayU8)this.image).data[imageIndex++] & 0xFF) - imageMean;
                    imageSigma += diff * diff;
                    top += diff * ((float)templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma / this.area);
            return top / (imageSigma * this.templateSigma);
        }

        @Override
        protected float evaluateMask(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            int imageSum = 0;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((GrayU8)this.template).height; ++y) {
                imageIndex = ((GrayU8)this.image).startIndex + (tl_y + y) * ((GrayU8)this.image).stride + tl_x;
                for (int x = 0; x < ((GrayU8)this.template).width; ++x) {
                    imageSum += ((GrayU8)this.image).data[imageIndex++] & 0xFF;
                }
            }
            imageMean = (float)imageSum / this.area;
            for (y = 0; y < ((GrayU8)this.template).height; ++y) {
                imageIndex = ((GrayU8)this.image).startIndex + (tl_y + y) * ((GrayU8)this.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.template).startIndex + y * ((GrayU8)this.template).stride;
                int maskIndex = ((GrayU8)this.mask).startIndex + y * ((GrayU8)this.mask).stride;
                for (int x = 0; x < ((GrayU8)this.template).width; ++x) {
                    int templateVal = ((GrayU8)this.template).data[templateIndex++] & 0xFF;
                    int m = ((GrayU8)this.mask).data[maskIndex++] & 0xFF;
                    float diff = (float)(((GrayU8)this.image).data[imageIndex++] & 0xFF) - imageMean;
                    imageSigma += diff * diff;
                    top += (float)m * diff * ((float)templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma / this.area);
            return top / (imageSigma * this.templateSigma);
        }

        @Override
        public void setupTemplate(GrayU8 template) {
            int x;
            int templateIndex;
            int y;
            this.area = template.width * template.height;
            this.templateMean = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    this.templateMean += (float)(template.data[templateIndex++] & 0xFF);
                }
            }
            this.templateMean /= this.area;
            this.templateSigma = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    float diff = (float)(template.data[templateIndex++] & 0xFF) - this.templateMean;
                    this.templateSigma += diff * diff;
                }
            }
            this.templateSigma = (float)Math.sqrt(this.templateSigma / this.area);
        }
    }

    public static class F32
    extends TemplateNCC<GrayF32> {
        float area;
        float templateMean;
        float templateSigma;

        @Override
        protected float evaluate(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((GrayF32)this.template).height; ++y) {
                imageIndex = ((GrayF32)this.image).startIndex + (tl_y + y) * ((GrayF32)this.image).stride + tl_x;
                for (int x = 0; x < ((GrayF32)this.template).width; ++x) {
                    imageMean += ((GrayF32)this.image).data[imageIndex++];
                }
            }
            imageMean /= this.area;
            for (y = 0; y < ((GrayF32)this.template).height; ++y) {
                imageIndex = ((GrayF32)this.image).startIndex + (tl_y + y) * ((GrayF32)this.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.template).startIndex + y * ((GrayF32)this.template).stride;
                for (int x = 0; x < ((GrayF32)this.template).width; ++x) {
                    float templateVal = ((GrayF32)this.template).data[templateIndex++];
                    float diff = ((GrayF32)this.image).data[imageIndex++] - imageMean;
                    imageSigma += diff * diff;
                    top += diff * (templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma / this.area);
            return top / (imageSigma * this.templateSigma);
        }

        @Override
        protected float evaluateMask(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((GrayF32)this.template).height; ++y) {
                imageIndex = ((GrayF32)this.image).startIndex + (tl_y + y) * ((GrayF32)this.image).stride + tl_x;
                for (int x = 0; x < ((GrayF32)this.template).width; ++x) {
                    imageMean += ((GrayF32)this.image).data[imageIndex++];
                }
            }
            imageMean /= this.area;
            for (y = 0; y < ((GrayF32)this.template).height; ++y) {
                imageIndex = ((GrayF32)this.image).startIndex + (tl_y + y) * ((GrayF32)this.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.template).startIndex + y * ((GrayF32)this.template).stride;
                int maskIndex = ((GrayF32)this.mask).startIndex + y * ((GrayF32)this.mask).stride;
                for (int x = 0; x < ((GrayF32)this.template).width; ++x) {
                    float templateVal = ((GrayF32)this.template).data[templateIndex++];
                    float diff = ((GrayF32)this.image).data[imageIndex++] - imageMean;
                    imageSigma += diff * diff;
                    top += ((GrayF32)this.mask).data[maskIndex++] * diff * (templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma / this.area);
            return top / (imageSigma * this.templateSigma);
        }

        @Override
        public void setupTemplate(GrayF32 template) {
            int x;
            int templateIndex;
            int y;
            this.area = template.width * template.height;
            this.templateMean = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    this.templateMean += template.data[templateIndex++];
                }
            }
            this.templateMean /= this.area;
            this.templateSigma = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    float diff = template.data[templateIndex++] - this.templateMean;
                    this.templateSigma += diff * diff;
                }
            }
            this.templateSigma = (float)Math.sqrt(this.templateSigma / this.area);
        }
    }
}

