/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity;

import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.struct.image.ImageGray;

public abstract class SelectRectStandard<Array, T extends ImageGray>
implements DisparitySelect<Array, T> {
    protected T imageDisparity;
    protected int minDisparity;
    protected int maxDisparity;
    protected int rangeDisparity;
    protected int invalidDisparity;
    protected int localMax;
    protected int radiusX;
    protected int regionWidth;
    protected int maxError;
    protected int rightToLeftTolerance;

    public SelectRectStandard(int maxError, int rightToLeftTolerance, double texture) {
        this.maxError = maxError <= 0 ? Integer.MAX_VALUE : maxError;
        this.rightToLeftTolerance = rightToLeftTolerance;
        this.setTexture(texture);
    }

    public abstract void setTexture(double var1);

    @Override
    public void configure(T imageDisparity, int minDisparity, int maxDisparity, int radiusX) {
        this.imageDisparity = imageDisparity;
        this.minDisparity = minDisparity;
        this.maxDisparity = maxDisparity;
        this.radiusX = radiusX;
        this.rangeDisparity = maxDisparity - minDisparity;
        this.regionWidth = radiusX * 2 + 1;
        this.invalidDisparity = this.rangeDisparity + 1;
    }

    protected abstract void setDisparity(int var1, int var2);

    protected int maxDisparityAtColumnL2R(int col) {
        return 1 + col - this.minDisparity - Math.max(0, col - this.maxDisparity + 1);
    }

    public void setLocalMax(int value) {
        this.localMax = value;
    }
}

