/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.alg.InputSanityCheck;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageGray;

public abstract class OrientationSlidingWindow<D extends ImageGray>
implements OrientationGradient<D> {
    protected int pixelRadius;
    protected double objectRadiusToScale;
    protected D derivX;
    protected D derivY;
    protected ImageRectangle rect = new ImageRectangle();
    protected int numAngles;
    protected double windowSize;
    protected double[] angles;
    protected boolean isWeighted;
    protected Kernel2D_F32 weights;

    public OrientationSlidingWindow(double objectRadiusToScale, int numAngles, double windowSize, boolean isWeighted) {
        this.objectRadiusToScale = objectRadiusToScale;
        this.numAngles = numAngles;
        this.windowSize = windowSize;
        this.isWeighted = isWeighted;
    }

    public Kernel2D_F32 getWeights() {
        return this.weights;
    }

    @Override
    public void setObjectRadius(double objRadius) {
        this.pixelRadius = (int)Math.ceil(objRadius * this.objectRadiusToScale);
        if (this.isWeighted) {
            this.weights = (Kernel2D_F32)FactoryKernelGaussian.gaussian((int)2, (boolean)true, (int)32, (double)-1.0, (int)this.pixelRadius);
        }
        int w = this.pixelRadius * 2 + 1;
        this.angles = new double[w * w];
    }

    @Override
    public void setImage(D derivX, D derivY) {
        InputSanityCheck.checkSameShape(derivX, derivY);
        this.derivX = derivX;
        this.derivY = derivY;
    }

    @Override
    public double compute(double X, double Y) {
        int c_x = (int)X;
        int c_y = (int)Y;
        this.rect.x0 = c_x - this.pixelRadius;
        this.rect.y0 = c_y - this.pixelRadius;
        this.rect.x1 = c_x + this.pixelRadius + 1;
        this.rect.y1 = c_y + this.pixelRadius + 1;
        BoofMiscOps.boundRectangleInside(this.derivX, (ImageRectangle)this.rect);
        if (this.isWeighted) {
            return this.computeWeightedOrientation(c_x, c_y);
        }
        return this.computeOrientation();
    }

    protected abstract double computeOrientation();

    protected abstract double computeWeightedOrientation(int var1, int var2);
}

