/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.alg.shapes.edge.EdgeIntensityPolygon;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.alg.shapes.polyline.MinimizeEnergyPrune;
import boofcv.alg.shapes.polyline.RefinePolyLineCorner;
import boofcv.alg.shapes.polyline.SplitMergeLineFitLoop;
import boofcv.struct.ConnectRule;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Area2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_B;
import org.ddogleg.struct.GrowQueue_I32;

public class BinaryPolygonDetector<T extends ImageGray> {
    private double minContourFraction;
    private int minimumContour;
    private double minimumArea;
    private boolean convex;
    private LinearContourLabelChang2004 contourFinder = new LinearContourLabelChang2004(ConnectRule.FOUR);
    private GrayS32 labeled = new GrayS32(1, 1);
    private SplitMergeLineFitLoop fitPolygon;
    GrowQueue_I32 pruned = new GrowQueue_I32();
    MinimizeEnergyPrune pruner;
    private RefinePolyLineCorner improveContour = new RefinePolyLineCorner(true, 20);
    private RefineBinaryPolygon<T> refinePolygon;
    private FastQueue<Polygon2D_F64> found = new FastQueue(Polygon2D_F64.class, true);
    private FastQueue<Info> foundInfo = new FastQueue(Info.class, true);
    private Class<T> inputType;
    private int minSides;
    private int maxSides;
    private boolean canTouchBorder;
    private Polygon2D_F64 workPoly = new Polygon2D_F64();
    private boolean outputClockwise;
    private List<Contour> foundContours = new ArrayList<Contour>();
    protected PixelTransform2_F32 distToUndist;
    protected PixelTransform2_F32 undistToDist;
    boolean verbose = false;
    EdgeIntensityPolygon<T> edgeIntensity;
    double edgeThreshold;
    boolean checkEdgeBefore = true;
    private PolygonHelper helper;
    private FastQueue<Point2D_I32> contourUndist = new FastQueue(Point2D_I32.class, true);

    public BinaryPolygonDetector(int minSides, int maxSides, SplitMergeLineFitLoop contourToPolygon, RefineBinaryPolygon<T> refinePolygon, double minContourFraction, boolean outputClockwise, boolean convex, boolean touchBorder, double splitPenalty, double edgeThreshold, Class<T> inputType) {
        this.setNumberOfSides(minSides, maxSides);
        this.refinePolygon = refinePolygon;
        this.edgeIntensity = new EdgeIntensityPolygon<T>(1.0, 1.5, 15, inputType);
        this.inputType = inputType;
        this.minContourFraction = minContourFraction;
        this.fitPolygon = contourToPolygon;
        this.outputClockwise = outputClockwise;
        this.convex = convex;
        this.canTouchBorder = touchBorder;
        this.edgeThreshold = edgeThreshold;
        this.pruner = new MinimizeEnergyPrune(splitPenalty);
        this.workPoly = new Polygon2D_F64(1);
    }

    public void setLensDistortion(int width, int height, PixelTransform2_F32 distToUndist, PixelTransform2_F32 undistToDist) {
        this.distToUndist = distToUndist;
        this.undistToDist = undistToDist;
        if (this.refinePolygon != null) {
            this.refinePolygon.setLensDistortion(width, height, distToUndist, undistToDist);
        }
        this.edgeIntensity.setTransform(undistToDist);
    }

    public void clearLensDistortion() {
        this.distToUndist = null;
        this.undistToDist = null;
        if (this.refinePolygon != null) {
            this.refinePolygon.clearLensDistortion();
        }
        this.edgeIntensity.setTransform(null);
    }

    public void process(T gray, GrayU8 binary) {
        if (this.verbose) {
            System.out.println("ENTER  BinaryPolygonDetector.process()");
        }
        InputSanityCheck.checkSameShape((ImageBase)binary, gray);
        if (this.labeled.width != ((ImageGray)gray).width || this.labeled.height == ((ImageGray)gray).width) {
            this.configure(((ImageGray)gray).width, ((ImageGray)gray).height);
        }
        this.found.reset();
        this.foundContours.clear();
        this.foundInfo.reset();
        this.edgeIntensity.setImage(gray);
        this.findCandidateShapes(gray, binary);
        if (this.verbose) {
            System.out.println("EXIT  BinaryPolygonDetector.process()");
        }
    }

    private void configure(int width, int height) {
        this.labeled.reshape(width, height);
        this.minimumContour = (int)((double)width * this.minContourFraction);
        this.minimumArea = Math.pow((double)this.minimumContour / 4.0, 2.0);
        if (this.helper != null) {
            this.helper.setImageShape(width, height);
        }
    }

    private void findCandidateShapes(T gray, GrayU8 binary) {
        int maxSidesConsider = (int)Math.ceil((double)this.maxSides * 1.5);
        this.fitPolygon.setAbortSplits(2 * this.maxSides);
        this.contourFinder.process(binary, this.labeled);
        FastQueue blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size; ++i) {
            boolean refinedCCW;
            boolean success;
            List contourUndist;
            Contour c = (Contour)blobs.get(i);
            if (c.external.size() < this.minimumContour) continue;
            boolean touchesBorder = this.touchesBorder(c.external);
            if (!this.canTouchBorder && touchesBorder) {
                if (!this.verbose) continue;
                System.out.println("rejected polygon, touched border");
                continue;
            }
            if (this.helper != null && !this.helper.filterContour(c.external, touchesBorder, true)) continue;
            if (this.distToUndist != null) {
                this.removeDistortionFromContour(c.external, this.contourUndist);
                contourUndist = this.contourUndist.toList();
                if (this.helper != null && !this.helper.filterContour(contourUndist, touchesBorder, false)) {
                    continue;
                }
            } else {
                contourUndist = c.external;
            }
            if (!this.fitPolygon.process(contourUndist)) {
                if (!this.verbose) continue;
                System.out.println("rejected polygon initial fit failed. contour size = " + c.external.size());
                continue;
            }
            GrowQueue_I32 splits = this.fitPolygon.getSplits();
            if (splits.size() > maxSidesConsider) {
                if (!this.verbose) continue;
                System.out.println("Way too many corners, " + splits.size() + ". Aborting before improve. Contour size " + c.external.size());
                continue;
            }
            if (!this.improveContour.fit(contourUndist, splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected improve contour. contour size = " + c.external.size());
                continue;
            }
            this.pruner.prune(c.external, splits, this.pruned);
            splits = this.pruned;
            if (!this.expectedNumberOfSides(splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected number of sides. " + splits.size() + "  contour " + c.external.size());
                continue;
            }
            if (this.helper != null && !this.helper.filterPixelPolygon(contourUndist, c.external, splits, touchesBorder)) {
                if (!this.verbose) continue;
                System.out.println("rejected by helper.filterPixelPolygon()");
                continue;
            }
            this.workPoly.vertexes.resize(splits.size());
            for (int j = 0; j < splits.size(); ++j) {
                Point2D_I32 p = (Point2D_I32)contourUndist.get(splits.get(j));
                this.workPoly.get(j).set((double)p.x, (double)p.y);
            }
            if (this.helper != null) {
                this.helper.adjustBeforeOptimize(this.workPoly);
            }
            if (this.convex && !UtilPolygons2D_F64.isConvex((Polygon2D_F64)this.workPoly)) {
                if (!this.verbose) continue;
                System.out.println("Rejected not convex");
                continue;
            }
            double area = Area2D_F64.polygonSimple((Polygon2D_F64)this.workPoly);
            if (area < this.minimumArea) {
                if (!this.verbose) continue;
                System.out.println("Rejected area");
                continue;
            }
            if (this.checkEdgeBefore && !this.checkPolygonEdge(this.workPoly, this.workPoly.isCCW())) continue;
            Polygon2D_F64 refined = (Polygon2D_F64)this.found.grow();
            refined.vertexes.resize(splits.size);
            if (this.refinePolygon != null) {
                this.refinePolygon.setImage(gray);
                success = this.refinePolygon.refine(this.workPoly, contourUndist, splits, refined);
                if (this.verbose && !success) {
                    System.out.println("Rejected after refinePolygon");
                }
            } else {
                refined.set(this.workPoly);
                success = true;
            }
            if (!this.checkPolygonEdge(refined, refinedCCW = refined.isCCW())) {
                if (this.verbose) {
                    System.out.println("Rejected edge score, after");
                }
                success = false;
            }
            if (success) {
                if (this.outputClockwise == refinedCCW) {
                    refined.flip();
                }
                c.id = this.found.size();
                this.foundContours.add(c);
                Info info = (Info)this.foundInfo.grow();
                info.external = true;
                info.borderCorners.reset();
                if (touchesBorder) {
                    this.determineCornersOnBorder(refined, info.borderCorners, 0.7f);
                }
                info.edgeInside = this.edgeIntensity.getAverageInside();
                info.edgeOutside = this.edgeIntensity.getAverageOutside();
                continue;
            }
            this.found.removeTail();
        }
    }

    void determineCornersOnBorder(Polygon2D_F64 polygon, GrowQueue_B corners, float tol) {
        corners.reset();
        for (int i = 0; i < polygon.size(); ++i) {
            corners.add(this.isUndistortedOnBorder(polygon.get(i), tol));
        }
    }

    boolean isUndistortedOnBorder(Point2D_F64 undistorted, float tol) {
        float y;
        float x;
        if (this.undistToDist == null) {
            x = (float)undistorted.x;
            y = (float)undistorted.y;
        } else {
            this.undistToDist.compute((int)Math.round(undistorted.x), (int)Math.round(undistorted.y));
            x = this.undistToDist.distX;
            y = this.undistToDist.distY;
        }
        return x <= tol || y <= tol || x + tol >= (float)(this.labeled.width - 1) || y + tol >= (float)(this.labeled.height - 1);
    }

    private boolean checkPolygonEdge(Polygon2D_F64 polygon, boolean ccw) {
        if (!this.edgeIntensity.computeEdge(polygon, ccw)) {
            if (this.verbose) {
                System.out.println("Can't compute polygon edge intensity");
            }
            return false;
        }
        if (!this.edgeIntensity.checkIntensity(true, this.edgeThreshold)) {
            if (this.verbose) {
                double inside = this.edgeIntensity.getAverageInside();
                double outside = this.edgeIntensity.getAverageOutside();
                System.out.println("Rejected edge score inside: " + inside + " " + outside);
            }
            return false;
        }
        return true;
    }

    private boolean expectedNumberOfSides(GrowQueue_I32 splits) {
        return splits.size() >= this.minSides && splits.size() <= this.maxSides;
    }

    private void removeDistortionFromContour(List<Point2D_I32> distorted, FastQueue<Point2D_I32> undistorted) {
        undistorted.reset();
        for (int j = 0; j < distorted.size(); ++j) {
            Point2D_I32 p = distorted.get(j);
            this.distToUndist.compute(p.x, p.y);
            int x = Math.round(this.distToUndist.distX);
            int y = Math.round(this.distToUndist.distY);
            ((Point2D_I32)undistorted.grow()).set(x, y);
        }
    }

    protected final boolean touchesBorder(List<Point2D_I32> contour) {
        int endX = this.labeled.width - 1;
        int endY = this.labeled.height - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != endX && p.y != endY) continue;
            return true;
        }
        return false;
    }

    public void setHelper(PolygonHelper helper) {
        this.helper = helper;
    }

    public boolean isConvex() {
        return this.convex;
    }

    public void setConvex(boolean convex) {
        this.convex = convex;
    }

    public GrayS32 getLabeled() {
        return this.labeled;
    }

    public boolean isOutputClockwise() {
        return this.outputClockwise;
    }

    public FastQueue<Polygon2D_F64> getFoundPolygons() {
        return this.found;
    }

    public List<Contour> getUsedContours() {
        return this.foundContours;
    }

    public List<Contour> getAllContours() {
        return this.contourFinder.getContours().toList();
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setNumberOfSides(int min, int max) {
        if (min < 3) {
            throw new IllegalArgumentException("The min must be >= 3");
        }
        if (max < min) {
            throw new IllegalArgumentException("The max must be >= the min");
        }
        this.minSides = min;
        this.maxSides = max;
    }

    public int getMinimumSides() {
        return this.minSides;
    }

    public int getMaximumSides() {
        return this.maxSides;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isCheckEdgeBefore() {
        return this.checkEdgeBefore;
    }

    public RefineBinaryPolygon<T> getRefinePolygon() {
        return this.refinePolygon;
    }

    public void setRefinePolygon(RefineBinaryPolygon<T> refinePolygon) {
        this.refinePolygon = refinePolygon;
    }

    public double getEdgeThreshold() {
        return this.edgeThreshold;
    }

    public void setEdgeThreshold(double edgeThreshold) {
        this.edgeThreshold = edgeThreshold;
    }

    public PixelTransform2_F32 getDistToUndist() {
        return this.distToUndist;
    }

    public PixelTransform2_F32 getUndistToDist() {
        return this.undistToDist;
    }

    public FastQueue<Info> getPolygonInfo() {
        return this.foundInfo;
    }

    public void setCheckEdgeBefore(boolean checkEdgeBefore) {
        this.checkEdgeBefore = checkEdgeBefore;
    }

    public static class Info {
        public boolean external;
        public double edgeInside;
        public double edgeOutside;
        public GrowQueue_B borderCorners = new GrowQueue_B();
    }
}

