/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline;

import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.GrowQueue_B;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class SplitMergeLineFit {
    protected int maxIterations;
    protected double toleranceFractionSq;
    protected double minimumSideLengthFraction;
    protected int minimumSideLengthPixel;
    protected List<Point2D_I32> contour;
    protected LineParametric2D_F64 line = new LineParametric2D_F64();
    protected Point2D_F64 point2D = new Point2D_F64();
    protected GrowQueue_I32 splits = new GrowQueue_I32();
    protected GrowQueue_I32 work = new GrowQueue_I32();
    protected GrowQueue_B changed = new GrowQueue_B();
    protected int abortSplits = Integer.MAX_VALUE;

    public SplitMergeLineFit(double splitFraction, double minimumSideLengthFraction, int maxIterations) {
        this.setSplitFraction(splitFraction);
        this.setMinimumSideLengthFraction(minimumSideLengthFraction);
        this.setMaxIterations(maxIterations);
    }

    public abstract boolean process(List<Point2D_I32> var1);

    protected double splitThresholdSq(Point2D_I32 a, Point2D_I32 b) {
        return Math.max(2.0, (double)a.distance2(b) * this.toleranceFractionSq);
    }

    public GrowQueue_I32 getSplits() {
        return this.splits;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setSplitFraction(double toleranceSplit) {
        this.toleranceFractionSq = toleranceSplit * toleranceSplit;
    }

    public int getAbortSplits() {
        return this.abortSplits;
    }

    public void setAbortSplits(int abortSplits) {
        this.abortSplits = abortSplits;
    }

    public double getMinimumSideLengthFraction() {
        return this.minimumSideLengthFraction;
    }

    public void setMinimumSideLengthFraction(double minimumSideLengthFraction) {
        if (minimumSideLengthFraction >= 1.0 || minimumSideLengthFraction < 0.0) {
            throw new IllegalArgumentException("The minimumSplitFraction must be 0 <= val < 1 ");
        }
        this.minimumSideLengthFraction = minimumSideLengthFraction;
    }
}

