/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import java.util.Arrays;
import org.ejml.alg.dense.decomposition.svd.SafeSvd;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class AdjustHomographyMatrix {
    protected SingularValueDecomposition<DenseMatrix64F> svd = new SafeSvd(DecompositionFactory.svd((int)0, (int)0, (boolean)true, (boolean)true, (boolean)false));
    DenseMatrix64F H_t = new DenseMatrix64F(3, 3);

    public boolean adjust(DenseMatrix64F H, AssociatedPair p) {
        if (!this.findScaleH(H)) {
            return false;
        }
        this.adjustHomographSign(p, H);
        return true;
    }

    public boolean adjust(DenseMatrix64F H, PairLineNorm p) {
        if (!this.findScaleH(H)) {
            return false;
        }
        this.adjustHomographSign(p, H);
        return true;
    }

    protected boolean findScaleH(DenseMatrix64F H) {
        if (!this.svd.decompose((Matrix64F)H)) {
            return false;
        }
        Arrays.sort(this.svd.getSingularValues(), 0, 3);
        double scale = this.svd.getSingularValues()[1];
        CommonOps.divide((double)scale, (D1Matrix64F)H);
        return true;
    }

    protected void adjustHomographSign(AssociatedPair p, DenseMatrix64F H) {
        double val = GeometryMath_F64.innerProd((GeoTuple2D_F64)p.p2, (DenseMatrix64F)H, (GeoTuple2D_F64)p.p1);
        if (val < 0.0) {
            CommonOps.scale((double)-1.0, (D1Matrix64F)H);
        }
    }

    protected void adjustHomographSign(PairLineNorm p, DenseMatrix64F H) {
        CommonOps.transpose((DenseMatrix64F)H, (DenseMatrix64F)this.H_t);
        double val = GeometryMath_F64.innerProd((GeoTuple3D_F64)p.l1, (DenseMatrix64F)this.H_t, (GeoTuple3D_F64)p.l2);
        if (val < 0.0) {
            CommonOps.scale((double)-1.0, (D1Matrix64F)H);
        }
    }
}

