/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class Relinearlize {
    int numControl;
    int numNull;
    DenseMatrix64F V;
    DenseMatrix64F x0 = new DenseMatrix64F(1, 1);
    int[] table = new int[100];
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)3, (boolean)false, (boolean)true, (boolean)false);
    DenseMatrix64F AA = new DenseMatrix64F(1, 1);
    DenseMatrix64F yy = new DenseMatrix64F(1, 1);
    DenseMatrix64F xx = new DenseMatrix64F(1, 1);
    LinearSolver<DenseMatrix64F> pseudo = LinearSolverFactory.pseudoInverse((boolean)true);
    double[] XiiXjk = new double[10];
    double[] XikXji = new double[10];

    public void setNumberControl(int numControl) {
        this.numControl = numControl;
        if (numControl == 4) {
            this.x0.reshape(10, 1, false);
            this.AA.reshape(10, 9, false);
            this.yy.reshape(10, 1, false);
            this.xx.reshape(9, 1, false);
            this.numNull = 3;
        } else {
            this.x0.reshape(6, 1, false);
            this.AA.reshape(4, 2, false);
            this.yy.reshape(4, 1, false);
            this.xx.reshape(2, 1, false);
            this.numNull = 1;
        }
        int index = 0;
        for (int i = 0; i < numControl; ++i) {
            for (int j = i; j < numControl; ++j) {
                int n = index++;
                this.table[j * numControl + i] = n;
                this.table[i * numControl + j] = n;
            }
        }
    }

    public void process(DenseMatrix64F L_full, DenseMatrix64F y, double[] betas) {
        this.svd.decompose((Matrix64F)L_full);
        this.V = (DenseMatrix64F)this.svd.getV(null, true);
        this.pseudo.setA((Matrix64F)L_full);
        this.pseudo.solve((Matrix64F)y, (Matrix64F)this.x0);
        DenseMatrix64F alphas = this.solveConstraintMatrix();
        for (int i = 0; i < this.x0.numRows; ++i) {
            for (int j = 0; j < this.numNull; ++j) {
                int n = i;
                this.x0.data[n] = this.x0.data[n] + alphas.data[j] * this.valueNull(j, i);
            }
        }
        if (this.numControl == 4) {
            betas[0] = Math.sqrt(Math.abs(this.x0.data[0]));
            betas[1] = Math.sqrt(Math.abs(this.x0.data[4])) * Math.signum(this.x0.data[1]);
            betas[2] = Math.sqrt(Math.abs(this.x0.data[7])) * Math.signum(this.x0.data[2]);
            betas[3] = Math.sqrt(Math.abs(this.x0.data[9])) * Math.signum(this.x0.data[3]);
        } else {
            betas[0] = Math.sqrt(Math.abs(this.x0.data[0]));
            betas[1] = Math.sqrt(Math.abs(this.x0.data[3])) * Math.signum(this.x0.data[1]);
            betas[2] = Math.sqrt(Math.abs(this.x0.data[5])) * Math.signum(this.x0.data[2]);
        }
    }

    protected DenseMatrix64F solveConstraintMatrix() {
        int rowAA = 0;
        for (int i = 0; i < this.numControl; ++i) {
            for (int j = i + 1; j < this.numControl; ++j) {
                int k = j;
                while (k < this.numControl) {
                    this.extractXaXb(this.getIndex(i, i), this.getIndex(j, k), this.XiiXjk);
                    this.extractXaXb(this.getIndex(i, k), this.getIndex(j, i), this.XikXji);
                    for (int l = 1; l <= this.AA.numCols; ++l) {
                        this.AA.set(rowAA, l - 1, this.XikXji[l] - this.XiiXjk[l]);
                    }
                    this.yy.set(rowAA, this.XiiXjk[0] - this.XikXji[0]);
                    ++k;
                    ++rowAA;
                }
            }
        }
        CommonOps.solve((DenseMatrix64F)this.AA, (DenseMatrix64F)this.yy, (DenseMatrix64F)this.xx);
        return this.xx;
    }

    public double valueNull(int which, int index) {
        return this.V.get(this.V.numCols - this.numControl + which, index);
    }

    private int getIndex(int i, int j) {
        return this.table[i * this.numControl + j];
    }

    private void extractXaXb(int indexA, int indexB, double[] quadratic) {
        double x0a = this.x0.get(indexA);
        double v0a = this.valueNull(0, indexA);
        double x0b = this.x0.get(indexB);
        double v0b = this.valueNull(0, indexB);
        if (this.numControl == 4) {
            double v1a = this.valueNull(1, indexA);
            double v2a = this.valueNull(2, indexA);
            double v1b = this.valueNull(1, indexB);
            double v2b = this.valueNull(2, indexB);
            this.multiplyQuadratic4(x0a, v0a, v1a, v2a, x0b, v0b, v1b, v2b, quadratic);
        } else {
            this.multiplyQuadratic2(x0a, v0a, x0b, v0b, quadratic);
        }
    }

    private void multiplyQuadratic4(double x0, double x1, double x2, double x3, double y0, double y1, double y2, double y3, double[] quadratic) {
        quadratic[0] = x0 * y0;
        quadratic[1] = x0 * y1 + y0 * x1;
        quadratic[2] = x0 * y2 + y0 * x2;
        quadratic[3] = x0 * y3 + y0 * x3;
        quadratic[4] = x1 * y1;
        quadratic[5] = x1 * y2 + y1 * x2;
        quadratic[6] = x1 * y3 + y1 * x3;
        quadratic[7] = x2 * y2;
        quadratic[8] = x2 * y3 + y2 * x3;
        quadratic[9] = x3 * y3;
    }

    private void multiplyQuadratic2(double x0, double x1, double y0, double y1, double[] quadratic) {
        quadratic[0] = x0 * y0;
        quadratic[1] = x0 * y1 + y0 * x1;
        quadratic[2] = x1 * y1;
    }
}

