/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.IntrinsicParameters;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.Serializable;
import org.ejml.data.DenseMatrix64F;

public class StereoParameters
implements Serializable {
    public static final long serialVersionUID = 1L;
    public IntrinsicParameters left;
    public IntrinsicParameters right;
    public Se3_F64 rightToLeft;

    public StereoParameters(StereoParameters param) {
        this(param.left, param.right, param.getRightToLeft());
    }

    public StereoParameters(IntrinsicParameters left, IntrinsicParameters right, Se3_F64 rightToLeft) {
        this.left = new IntrinsicParameters(left);
        this.rightToLeft = rightToLeft.copy();
        this.right = new IntrinsicParameters(right);
    }

    public StereoParameters() {
    }

    public IntrinsicParameters getLeft() {
        return this.left;
    }

    public void setLeft(IntrinsicParameters left) {
        this.left = left;
    }

    public Se3_F64 getRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(Se3_F64 rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public IntrinsicParameters getRight() {
        return this.right;
    }

    public void setRight(IntrinsicParameters right) {
        this.right = right;
    }

    public double getBaseline() {
        return this.rightToLeft.getT().norm();
    }

    public void print() {
        double[] euler = RotationMatrixGenerator.matrixToEulerXYZ((DenseMatrix64F)this.rightToLeft.getR(), null);
        Vector3D_F64 t = this.rightToLeft.getT();
        System.out.println();
        System.out.println("Left Camera");
        this.left.print();
        System.out.println();
        System.out.println("Right Camera");
        this.right.print();
        System.out.println("Right to Left");
        System.out.printf("  Euler XYZ   [ %8.3f , %8.3f , %8.3f ]\n", euler[0], euler[1], euler[2]);
        System.out.printf("  Translation [ %8.3f , %8.3f , %8.3f ]\n", t.x, t.y, t.z);
    }
}

