/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.geo;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public class TrifocalTensor {
    public DenseMatrix64F T1 = new DenseMatrix64F(3, 3);
    public DenseMatrix64F T2 = new DenseMatrix64F(3, 3);
    public DenseMatrix64F T3 = new DenseMatrix64F(3, 3);

    public DenseMatrix64F getT(int index) {
        switch (index) {
            case 0: {
                return this.T1;
            }
            case 1: {
                return this.T2;
            }
            case 2: {
                return this.T3;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    public void set(TrifocalTensor a) {
        this.T1.set((D1Matrix64F)a.T1);
        this.T2.set((D1Matrix64F)a.T2);
        this.T3.set((D1Matrix64F)a.T3);
    }

    public void convertFrom(DenseMatrix64F m) {
        if (m.getNumElements() != 27) {
            throw new IllegalArgumentException("Input matrix/vector must have 27 elements");
        }
        for (int i = 0; i < 9; ++i) {
            this.T1.data[i] = m.data[i];
            this.T2.data[i] = m.data[i + 9];
            this.T3.data[i] = m.data[i + 18];
        }
    }

    public void convertTo(DenseMatrix64F m) {
        if (m.getNumElements() != 27) {
            throw new IllegalArgumentException("Input matrix/vector must have 27 elements");
        }
        for (int i = 0; i < 9; ++i) {
            m.data[i] = this.T1.data[i];
            m.data[i + 9] = this.T2.data[i];
            m.data[i + 18] = this.T3.data[i];
        }
    }

    public TrifocalTensor copy() {
        TrifocalTensor ret = new TrifocalTensor();
        ret.T1.set((D1Matrix64F)this.T1);
        ret.T2.set((D1Matrix64F)this.T2);
        ret.T3.set((D1Matrix64F)this.T3);
        return ret;
    }

    public void normalizeScale() {
        double sum = 0.0;
        sum += SpecializedOps.elementSumSq((D1Matrix64F)this.T1);
        sum += SpecializedOps.elementSumSq((D1Matrix64F)this.T2);
        double n = Math.sqrt(sum += SpecializedOps.elementSumSq((D1Matrix64F)this.T3));
        CommonOps.scale((double)(1.0 / n), (D1Matrix64F)this.T1);
        CommonOps.scale((double)(1.0 / n), (D1Matrix64F)this.T2);
        CommonOps.scale((double)(1.0 / n), (D1Matrix64F)this.T3);
    }

    public String toString() {
        return "TrifocalTensor {\nT1:\n" + this.T1 + "\nT2:\n" + this.T2 + "\nT3\n" + this.T3 + "}";
    }

    public void print() {
        System.out.println(this);
    }
}

