/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class PositionFromPairLinear2 {
    LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.leastSquares((int)300, (int)3);
    DenseMatrix64F A = new DenseMatrix64F(3, 3);
    DenseMatrix64F x = new DenseMatrix64F(3, 1);
    DenseMatrix64F b = new DenseMatrix64F(3, 1);
    Point3D_F64 RX = new Point3D_F64();
    Vector3D_F64 T = new Vector3D_F64();

    public boolean process(DenseMatrix64F R, List<Point3D_F64> worldPts, List<Point2D_F64> observed) {
        if (worldPts.size() != observed.size()) {
            throw new IllegalArgumentException("Number of worldPts and observed must be the same");
        }
        if (worldPts.size() < 2) {
            throw new IllegalArgumentException("A minimum of two points are required");
        }
        int N = worldPts.size();
        this.A.reshape(3 * N, 3);
        this.b.reshape(this.A.numRows, 1);
        for (int i = 0; i < N; ++i) {
            Point3D_F64 X = worldPts.get(i);
            Point2D_F64 o = observed.get(i);
            int indexA = i * 3 * 3;
            int indexB = i * 3;
            this.A.data[indexA + 1] = -1.0;
            this.A.data[indexA + 2] = o.y;
            this.A.data[indexA + 3] = 1.0;
            this.A.data[indexA + 5] = -o.x;
            this.A.data[indexA + 6] = -o.y;
            this.A.data[indexA + 7] = o.x;
            GeometryMath_F64.mult((DenseMatrix64F)R, (GeoTuple3D_F64)X, (GeoTuple3D_F64)this.RX);
            this.b.data[indexB++] = 1.0 * this.RX.y - o.y * this.RX.z;
            this.b.data[indexB++] = -1.0 * this.RX.x + o.x * this.RX.z;
            this.b.data[indexB] = o.y * this.RX.x - o.x * this.RX.y;
        }
        if (!this.solver.setA((Matrix64F)this.A)) {
            return false;
        }
        this.solver.solve((Matrix64F)this.b, (Matrix64F)this.x);
        this.T.x = this.x.data[0];
        this.T.y = this.x.data[1];
        this.T.z = this.x.data[2];
        return true;
    }

    public Vector3D_F64 getT() {
        return this.T;
    }
}

