/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class LowLevelMultiViewOps {
    public static void computeNormalization(List<Point2D_F64> points, DenseMatrix64F N) {
        double meanX1 = 0.0;
        double meanY1 = 0.0;
        for (Point2D_F64 p : points) {
            meanX1 += p.x;
            meanY1 += p.y;
        }
        meanX1 /= (double)points.size();
        meanY1 /= (double)points.size();
        double stdX1 = 0.0;
        double stdY1 = 0.0;
        for (Point2D_F64 p : points) {
            double dx = p.x - meanX1;
            double dy = p.y - meanY1;
            stdX1 += dx * dx;
            stdY1 += dy * dy;
        }
        stdX1 = Math.sqrt(stdX1 / (double)points.size());
        stdY1 = Math.sqrt(stdY1 / (double)points.size());
        N.zero();
        N.set(0, 0, 1.0 / stdX1);
        N.set(1, 1, 1.0 / stdY1);
        N.set(0, 2, -meanX1 / stdX1);
        N.set(1, 2, -meanY1 / stdY1);
        N.set(2, 2, 1.0);
    }

    public static void computeNormalization(List<AssociatedPair> points, DenseMatrix64F N1, DenseMatrix64F N2) {
        double meanX1 = 0.0;
        double meanY1 = 0.0;
        double meanX2 = 0.0;
        double meanY2 = 0.0;
        for (AssociatedPair p : points) {
            meanX1 += p.p1.x;
            meanY1 += p.p1.y;
            meanX2 += p.p2.x;
            meanY2 += p.p2.y;
        }
        meanX1 /= (double)points.size();
        meanY1 /= (double)points.size();
        meanX2 /= (double)points.size();
        meanY2 /= (double)points.size();
        double stdX1 = 0.0;
        double stdY1 = 0.0;
        double stdX2 = 0.0;
        double stdY2 = 0.0;
        for (AssociatedPair p : points) {
            double dx = p.p1.x - meanX1;
            double dy = p.p1.y - meanY1;
            stdX1 += dx * dx;
            stdY1 += dy * dy;
            dx = p.p2.x - meanX2;
            dy = p.p2.y - meanY2;
            stdX2 += dx * dx;
            stdY2 += dy * dy;
        }
        stdX1 = Math.sqrt(stdX1 / (double)points.size());
        stdY1 = Math.sqrt(stdY1 / (double)points.size());
        stdX2 = Math.sqrt(stdX2 / (double)points.size());
        stdY2 = Math.sqrt(stdY2 / (double)points.size());
        N1.zero();
        N2.zero();
        N1.set(0, 0, 1.0 / stdX1);
        N1.set(1, 1, 1.0 / stdY1);
        N1.set(0, 2, -meanX1 / stdX1);
        N1.set(1, 2, -meanY1 / stdY1);
        N1.set(2, 2, 1.0);
        N2.set(0, 0, 1.0 / stdX2);
        N2.set(1, 1, 1.0 / stdY2);
        N2.set(0, 2, -meanX2 / stdX2);
        N2.set(1, 2, -meanY2 / stdY2);
        N2.set(2, 2, 1.0);
    }

    public static void computeNormalization(List<AssociatedTriple> points, DenseMatrix64F N1, DenseMatrix64F N2, DenseMatrix64F N3) {
        double meanX1 = 0.0;
        double meanY1 = 0.0;
        double meanX2 = 0.0;
        double meanY2 = 0.0;
        double meanX3 = 0.0;
        double meanY3 = 0.0;
        for (AssociatedTriple p : points) {
            meanX1 += p.p1.x;
            meanY1 += p.p1.y;
            meanX2 += p.p2.x;
            meanY2 += p.p2.y;
            meanX3 += p.p3.x;
            meanY3 += p.p3.y;
        }
        meanX1 /= (double)points.size();
        meanY1 /= (double)points.size();
        meanX2 /= (double)points.size();
        meanY2 /= (double)points.size();
        meanX3 /= (double)points.size();
        meanY3 /= (double)points.size();
        double stdX1 = 0.0;
        double stdY1 = 0.0;
        double stdX2 = 0.0;
        double stdY2 = 0.0;
        double stdX3 = 0.0;
        double stdY3 = 0.0;
        for (AssociatedTriple p : points) {
            double dx = p.p1.x - meanX1;
            double dy = p.p1.y - meanY1;
            stdX1 += dx * dx;
            stdY1 += dy * dy;
            dx = p.p2.x - meanX2;
            dy = p.p2.y - meanY2;
            stdX2 += dx * dx;
            stdY2 += dy * dy;
            dx = p.p3.x - meanX3;
            dy = p.p3.y - meanY3;
            stdX3 += dx * dx;
            stdY3 += dy * dy;
        }
        stdX1 = Math.sqrt(stdX1 / (double)points.size());
        stdY1 = Math.sqrt(stdY1 / (double)points.size());
        stdX2 = Math.sqrt(stdX2 / (double)points.size());
        stdY2 = Math.sqrt(stdY2 / (double)points.size());
        stdX3 = Math.sqrt(stdX3 / (double)points.size());
        stdY3 = Math.sqrt(stdY3 / (double)points.size());
        N1.zero();
        N2.zero();
        N3.zero();
        N1.set(0, 0, 1.0 / stdX1);
        N1.set(1, 1, 1.0 / stdY1);
        N1.set(0, 2, -meanX1 / stdX1);
        N1.set(1, 2, -meanY1 / stdY1);
        N1.set(2, 2, 1.0);
        N2.set(0, 0, 1.0 / stdX2);
        N2.set(1, 1, 1.0 / stdY2);
        N2.set(0, 2, -meanX2 / stdX2);
        N2.set(1, 2, -meanY2 / stdY2);
        N2.set(2, 2, 1.0);
        N3.set(0, 0, 1.0 / stdX3);
        N3.set(1, 1, 1.0 / stdY3);
        N3.set(0, 2, -meanX3 / stdX3);
        N3.set(1, 2, -meanY3 / stdY3);
        N3.set(2, 2, 1.0);
    }

    public static void applyPixelNormalization(DenseMatrix64F N, Point2D_F64 orig, Point2D_F64 normed) {
        normed.x = orig.x * N.data[0] + N.data[2];
        normed.y = orig.y * N.data[4] + N.data[5];
    }
}

