/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.geo.DecomposeEssential;
import boofcv.alg.geo.DecomposeHomography;
import boofcv.alg.geo.h.HomographyInducedStereo2Line;
import boofcv.alg.geo.h.HomographyInducedStereo3Pts;
import boofcv.alg.geo.h.HomographyInducedStereoLinePt;
import boofcv.alg.geo.trifocal.TrifocalExtractEpipoles;
import boofcv.struct.Tuple2;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public class MultiViewOps {
    public static TrifocalTensor createTrifocal(DenseMatrix64F P2, DenseMatrix64F P3, TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        for (int col = 0; col < 3; ++col) {
            DenseMatrix64F T = ret.getT(col);
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                double a_left = P2.get(i, col);
                double a_right = P2.get(i, 3);
                for (int j = 0; j < 3; ++j) {
                    T.data[index++] = a_left * P3.get(j, 3) - a_right * P3.get(j, col);
                }
            }
        }
        return ret;
    }

    public static TrifocalTensor createTrifocal(Se3_F64 P2, Se3_F64 P3, TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        DenseMatrix64F R2 = P2.getR();
        DenseMatrix64F R3 = P3.getR();
        Vector3D_F64 T2 = P2.getT();
        Vector3D_F64 T3 = P3.getT();
        for (int col = 0; col < 3; ++col) {
            DenseMatrix64F T = ret.getT(col);
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                double a_left = R2.unsafe_get(i, col);
                double a_right = T2.getIndex(i);
                for (int j = 0; j < 3; ++j) {
                    T.data[index++] = a_left * T3.getIndex(j) - a_right * R3.unsafe_get(j, col);
                }
            }
        }
        return ret;
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Vector3D_F64 l1, Vector3D_F64 l2, Vector3D_F64 l3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        double x = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DenseMatrix64F)tensor.T1, (GeoTuple3D_F64)l3);
        double y = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DenseMatrix64F)tensor.T2, (GeoTuple3D_F64)l3);
        double z = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DenseMatrix64F)tensor.T3, (GeoTuple3D_F64)l3);
        GeometryMath_F64.cross((GeoTuple3D_F64)new Vector3D_F64(x, y, z), (GeoTuple3D_F64)l1, (GeoTuple3D_F64)ret);
        return ret;
    }

    public static double constraint(TrifocalTensor tensor, Point2D_F64 p1, Vector3D_F64 l2, Vector3D_F64 l3) {
        DenseMatrix64F sum = new DenseMatrix64F(3, 3);
        CommonOps.add((double)p1.x, (D1Matrix64F)tensor.T1, (D1Matrix64F)sum, (D1Matrix64F)sum);
        CommonOps.add((double)p1.y, (D1Matrix64F)tensor.T2, (D1Matrix64F)sum, (D1Matrix64F)sum);
        CommonOps.add((D1Matrix64F)tensor.T3, (D1Matrix64F)sum, (D1Matrix64F)sum);
        return GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DenseMatrix64F)sum, (GeoTuple3D_F64)l3);
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Point2D_F64 p1, Vector3D_F64 l2, Point2D_F64 p3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        DenseMatrix64F sum = new DenseMatrix64F(3, 3);
        CommonOps.add((double)p1.x, (D1Matrix64F)tensor.T1, (D1Matrix64F)sum, (D1Matrix64F)sum);
        CommonOps.add((double)p1.y, (D1Matrix64F)tensor.T2, (D1Matrix64F)sum, (D1Matrix64F)sum);
        CommonOps.add((D1Matrix64F)tensor.T3, (D1Matrix64F)sum, (D1Matrix64F)sum);
        Vector3D_F64 tempV = new Vector3D_F64();
        GeometryMath_F64.multTran((DenseMatrix64F)sum, (GeoTuple3D_F64)l2, (GeoTuple3D_F64)tempV);
        GeometryMath_F64.cross((GeoTuple3D_F64)tempV, (GeoTuple3D_F64)new Vector3D_F64(p3.x, p3.y, 1.0), (GeoTuple3D_F64)ret);
        return ret;
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Point2D_F64 p1, Point2D_F64 p2, Vector3D_F64 l3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        DenseMatrix64F sum = new DenseMatrix64F(3, 3);
        CommonOps.add((double)p1.x, (D1Matrix64F)tensor.T1, (D1Matrix64F)sum, (D1Matrix64F)sum);
        CommonOps.add((double)p1.y, (D1Matrix64F)tensor.T2, (D1Matrix64F)sum, (D1Matrix64F)sum);
        CommonOps.add((D1Matrix64F)tensor.T3, (D1Matrix64F)sum, (D1Matrix64F)sum);
        DenseMatrix64F cross2 = GeometryMath_F64.crossMatrix((double)p2.x, (double)p2.y, (double)1.0, null);
        DenseMatrix64F temp = new DenseMatrix64F(3, 3);
        CommonOps.mult((RowD1Matrix64F)cross2, (RowD1Matrix64F)sum, (RowD1Matrix64F)temp);
        GeometryMath_F64.mult((DenseMatrix64F)temp, (GeoTuple3D_F64)l3, (GeoTuple3D_F64)ret);
        return ret;
    }

    public static DenseMatrix64F constraint(TrifocalTensor tensor, Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        }
        DenseMatrix64F sum = new DenseMatrix64F(3, 3);
        CommonOps.add((double)p1.x, (D1Matrix64F)tensor.T1, (double)p1.y, (D1Matrix64F)tensor.T2, (D1Matrix64F)sum);
        CommonOps.add((D1Matrix64F)sum, (D1Matrix64F)tensor.T3, (D1Matrix64F)sum);
        DenseMatrix64F cross2 = GeometryMath_F64.crossMatrix((double)p2.x, (double)p2.y, (double)1.0, null);
        DenseMatrix64F cross3 = GeometryMath_F64.crossMatrix((double)p3.x, (double)p3.y, (double)1.0, null);
        DenseMatrix64F temp = new DenseMatrix64F(3, 3);
        CommonOps.mult((RowD1Matrix64F)cross2, (RowD1Matrix64F)sum, (RowD1Matrix64F)temp);
        CommonOps.mult((RowD1Matrix64F)temp, (RowD1Matrix64F)cross3, (RowD1Matrix64F)ret);
        return ret;
    }

    public static double constraint(DenseMatrix64F F, Point2D_F64 p1, Point2D_F64 p2) {
        return GeometryMath_F64.innerProd((GeoTuple2D_F64)p2, (DenseMatrix64F)F, (GeoTuple2D_F64)p1);
    }

    public static Point2D_F64 constraintHomography(DenseMatrix64F H, Point2D_F64 p1, Point2D_F64 outputP2) {
        if (outputP2 == null) {
            outputP2 = new Point2D_F64();
        }
        GeometryMath_F64.mult((DenseMatrix64F)H, (GeoTuple2D_F64)p1, (GeoTuple2D_F64)outputP2);
        return outputP2;
    }

    public static DenseMatrix64F inducedHomography13(TrifocalTensor tensor, Vector3D_F64 line2, DenseMatrix64F output) {
        if (output == null) {
            output = new DenseMatrix64F(3, 3);
        }
        DenseMatrix64F T = tensor.T1;
        output.data[0] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[3] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[6] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        T = tensor.T2;
        output.data[1] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[4] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[7] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        T = tensor.T3;
        output.data[2] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[5] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[8] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        return output;
    }

    public static DenseMatrix64F inducedHomography12(TrifocalTensor tensor, Vector3D_F64 line3, DenseMatrix64F output) {
        if (output == null) {
            output = new DenseMatrix64F(3, 3);
        }
        DenseMatrix64F T = tensor.T1;
        output.data[0] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[3] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[6] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        T = tensor.T2;
        output.data[1] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[4] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[7] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        T = tensor.T3;
        output.data[2] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[5] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[8] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        return output;
    }

    public static DenseMatrix64F homographyStereo3Pts(DenseMatrix64F F, AssociatedPair p1, AssociatedPair p2, AssociatedPair p3) {
        HomographyInducedStereo3Pts alg = new HomographyInducedStereo3Pts();
        alg.setFundamental(F, null);
        if (!alg.process(p1, p2, p3)) {
            return null;
        }
        return alg.getHomography();
    }

    public static DenseMatrix64F homographyStereoLinePt(DenseMatrix64F F, PairLineNorm line, AssociatedPair point) {
        HomographyInducedStereoLinePt alg = new HomographyInducedStereoLinePt();
        alg.setFundamental(F, null);
        alg.process(line, point);
        return alg.getHomography();
    }

    public static DenseMatrix64F homographyStereo2Lines(DenseMatrix64F F, PairLineNorm line0, PairLineNorm line1) {
        HomographyInducedStereo2Line alg = new HomographyInducedStereo2Line();
        alg.setFundamental(F, null);
        if (!alg.process(line0, line1)) {
            return null;
        }
        return alg.getHomography();
    }

    public static void extractEpipoles(TrifocalTensor tensor, Point3D_F64 e2, Point3D_F64 e3) {
        TrifocalExtractEpipoles extract = new TrifocalExtractEpipoles();
        extract.process(tensor, e2, e3);
    }

    public static void extractFundamental(TrifocalTensor tensor, DenseMatrix64F F2, DenseMatrix64F F3) {
        Point3D_F64 e2 = new Point3D_F64();
        Point3D_F64 e3 = new Point3D_F64();
        MultiViewOps.extractEpipoles(tensor, e2, e3);
        Point3D_F64 temp0 = new Point3D_F64();
        Point3D_F64 column = new Point3D_F64();
        for (int i = 0; i < 3; ++i) {
            DenseMatrix64F T = tensor.getT(i);
            GeometryMath_F64.mult((DenseMatrix64F)T, (GeoTuple3D_F64)e3, (GeoTuple3D_F64)temp0);
            GeometryMath_F64.cross((GeoTuple3D_F64)e2, (GeoTuple3D_F64)temp0, (GeoTuple3D_F64)column);
            F2.set(0, i, column.x);
            F2.set(1, i, column.y);
            F2.set(2, i, column.z);
            GeometryMath_F64.multTran((DenseMatrix64F)T, (GeoTuple3D_F64)e2, (GeoTuple3D_F64)temp0);
            GeometryMath_F64.cross((GeoTuple3D_F64)e3, (GeoTuple3D_F64)temp0, (GeoTuple3D_F64)column);
            F3.set(0, i, column.x);
            F3.set(1, i, column.y);
            F3.set(2, i, column.z);
        }
    }

    public static void extractCameraMatrices(TrifocalTensor tensor, DenseMatrix64F P2, DenseMatrix64F P3) {
        int i;
        Point3D_F64 e2 = new Point3D_F64();
        Point3D_F64 e3 = new Point3D_F64();
        MultiViewOps.extractEpipoles(tensor, e2, e3);
        Point3D_F64 temp0 = new Point3D_F64();
        Point3D_F64 column = new Point3D_F64();
        DenseMatrix64F temp1 = new DenseMatrix64F(3, 3);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                temp1.set(i, j, e3.getIndex(i) * e3.getIndex(j));
            }
            temp1.set(i, i, temp1.get(i, i) - 1.0);
        }
        for (i = 0; i < 3; ++i) {
            DenseMatrix64F T = tensor.getT(i);
            GeometryMath_F64.mult((DenseMatrix64F)T, (GeoTuple3D_F64)e3, (GeoTuple3D_F64)column);
            P2.set(0, i, column.x);
            P2.set(1, i, column.y);
            P2.set(2, i, column.z);
            P2.set(i, 3, e2.getIndex(i));
            GeometryMath_F64.multTran((DenseMatrix64F)T, (GeoTuple3D_F64)e2, (GeoTuple3D_F64)temp0);
            GeometryMath_F64.mult((DenseMatrix64F)temp1, (GeoTuple3D_F64)temp0, (GeoTuple3D_F64)column);
            P3.set(0, i, column.x);
            P3.set(1, i, column.y);
            P3.set(2, i, column.z);
            P3.set(i, 3, e3.getIndex(i));
        }
    }

    public static DenseMatrix64F createEssential(DenseMatrix64F R, Vector3D_F64 T) {
        DenseMatrix64F E = new DenseMatrix64F(3, 3);
        DenseMatrix64F T_hat = GeometryMath_F64.crossMatrix((GeoTuple3D_F64)T, null);
        CommonOps.mult((RowD1Matrix64F)T_hat, (RowD1Matrix64F)R, (RowD1Matrix64F)E);
        return E;
    }

    public static DenseMatrix64F createFundamental(DenseMatrix64F E, DenseMatrix64F K) {
        DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)K, (DenseMatrix64F)K_inv);
        DenseMatrix64F F = new DenseMatrix64F(3, 3);
        DenseMatrix64F temp = new DenseMatrix64F(3, 3);
        CommonOps.multTransA((RowD1Matrix64F)K_inv, (RowD1Matrix64F)E, (RowD1Matrix64F)temp);
        CommonOps.mult((RowD1Matrix64F)temp, (RowD1Matrix64F)K_inv, (RowD1Matrix64F)F);
        return F;
    }

    public static DenseMatrix64F createFundamental(DenseMatrix64F E, DenseMatrix64F K1, DenseMatrix64F K2) {
        DenseMatrix64F K1_inv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)K1, (DenseMatrix64F)K1_inv);
        DenseMatrix64F K2_inv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)K2, (DenseMatrix64F)K2_inv);
        DenseMatrix64F F = new DenseMatrix64F(3, 3);
        DenseMatrix64F temp = new DenseMatrix64F(3, 3);
        CommonOps.multTransA((RowD1Matrix64F)K2_inv, (RowD1Matrix64F)E, (RowD1Matrix64F)temp);
        CommonOps.mult((RowD1Matrix64F)temp, (RowD1Matrix64F)K1_inv, (RowD1Matrix64F)F);
        return F;
    }

    public static DenseMatrix64F createHomography(DenseMatrix64F R, Vector3D_F64 T, double d, Vector3D_F64 N) {
        DenseMatrix64F H = new DenseMatrix64F(3, 3);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)T, (GeoTuple3D_F64)N, (DenseMatrix64F)H);
        CommonOps.divide((D1Matrix64F)H, (double)d);
        CommonOps.addEquals((D1Matrix64F)H, (D1Matrix64F)R);
        return H;
    }

    public static DenseMatrix64F createHomography(DenseMatrix64F R, Vector3D_F64 T, double d, Vector3D_F64 N, DenseMatrix64F K) {
        DenseMatrix64F temp = new DenseMatrix64F(3, 3);
        DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
        DenseMatrix64F H = MultiViewOps.createHomography(R, T, d, N);
        CommonOps.mult((RowD1Matrix64F)K, (RowD1Matrix64F)H, (RowD1Matrix64F)temp);
        CommonOps.invert((DenseMatrix64F)K, (DenseMatrix64F)K_inv);
        CommonOps.mult((RowD1Matrix64F)temp, (RowD1Matrix64F)K_inv, (RowD1Matrix64F)H);
        return H;
    }

    public static void extractEpipoles(DenseMatrix64F F, Point3D_F64 e1, Point3D_F64 e2) {
        SimpleMatrix f = SimpleMatrix.wrap((DenseMatrix64F)F);
        SimpleSVD svd = f.svd();
        SimpleMatrix U = svd.getU();
        SimpleMatrix V = svd.getV();
        if (e2 != null) {
            e2.set(U.get(0, 2), U.get(1, 2), U.get(2, 2));
        }
        if (e1 != null) {
            e1.set(V.get(0, 2), V.get(1, 2), V.get(2, 2));
        }
    }

    public static DenseMatrix64F canonicalCamera(DenseMatrix64F F, Point3D_F64 e2, Vector3D_F64 v, double lambda) {
        DenseMatrix64F crossMatrix = new DenseMatrix64F(3, 3);
        GeometryMath_F64.crossMatrix((GeoTuple3D_F64)e2, (DenseMatrix64F)crossMatrix);
        DenseMatrix64F outer = new DenseMatrix64F(3, 3);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)e2, (GeoTuple3D_F64)v, (DenseMatrix64F)outer);
        DenseMatrix64F KR = new DenseMatrix64F(3, 3);
        CommonOps.mult((RowD1Matrix64F)crossMatrix, (RowD1Matrix64F)F, (RowD1Matrix64F)KR);
        CommonOps.add((D1Matrix64F)KR, (D1Matrix64F)outer, (D1Matrix64F)KR);
        DenseMatrix64F P = new DenseMatrix64F(3, 4);
        CommonOps.insert((RealMatrix64F)KR, (RealMatrix64F)P, (int)0, (int)0);
        P.set(0, 3, lambda * e2.x);
        P.set(1, 3, lambda * e2.y);
        P.set(2, 3, lambda * e2.z);
        return P;
    }

    public static void decomposeCameraMatrix(DenseMatrix64F P, DenseMatrix64F K, Se3_F64 pose) {
        DenseMatrix64F KR = new DenseMatrix64F(3, 3);
        CommonOps.extract((RealMatrix64F)P, (int)0, (int)3, (int)0, (int)3, (RealMatrix64F)KR, (int)0, (int)0);
        QRDecomposition qr = DecompositionFactory.qr((int)3, (int)3);
        if (!CommonOps.invert((DenseMatrix64F)KR)) {
            throw new RuntimeException("Inverse failed!  Bad input?");
        }
        if (!qr.decompose((Matrix)KR)) {
            throw new RuntimeException("QR decomposition failed!  Bad input?");
        }
        DenseMatrix64F U = (DenseMatrix64F)qr.getQ(null, false);
        DenseMatrix64F B = (DenseMatrix64F)qr.getR(null, false);
        if (!CommonOps.invert((DenseMatrix64F)U, (DenseMatrix64F)pose.getR())) {
            throw new RuntimeException("Inverse failed!  Bad input?");
        }
        Point3D_F64 KT = new Point3D_F64(P.get(0, 3), P.get(1, 3), P.get(2, 3));
        GeometryMath_F64.mult((DenseMatrix64F)B, (GeoTuple3D_F64)KT, (GeoTuple3D_F64)pose.getT());
        if (!CommonOps.invert((DenseMatrix64F)B, (DenseMatrix64F)K)) {
            throw new RuntimeException("Inverse failed!  Bad input?");
        }
        CommonOps.scale((double)(1.0 / K.get(2, 2)), (D1Matrix64F)K);
    }

    public static List<Se3_F64> decomposeEssential(DenseMatrix64F E) {
        DecomposeEssential d = new DecomposeEssential();
        d.decompose(E);
        return d.getSolutions();
    }

    public static List<Tuple2<Se3_F64, Vector3D_F64>> decomposeHomography(DenseMatrix64F H) {
        DecomposeHomography d = new DecomposeHomography();
        d.decompose(H);
        List<Vector3D_F64> solutionsN = d.getSolutionsN();
        List<Se3_F64> solutionsSe = d.getSolutionsSE();
        ArrayList<Tuple2<Se3_F64, Vector3D_F64>> ret = new ArrayList<Tuple2<Se3_F64, Vector3D_F64>>();
        for (int i = 0; i < 4; ++i) {
            ret.add((Tuple2<Se3_F64, Vector3D_F64>)new Tuple2((Object)solutionsSe.get(i), (Object)solutionsN.get(i)));
        }
        return ret;
    }
}

