/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.DistanceModelMonoPixels;
import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.geo.Point2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class PnPDistanceReprojectionSq
implements DistanceModelMonoPixels<Se3_F64, Point2D3D> {
    private Se3_F64 worldToCamera;
    private Point3D_F64 X = new Point3D_F64();
    private NormalizedToPixelError pixelError;

    public PnPDistanceReprojectionSq() {
        this(1.0, 1.0, 0.0);
    }

    public PnPDistanceReprojectionSq(double fx, double fy, double skew) {
        this.setIntrinsic(fx, fy, skew);
    }

    @Override
    public void setIntrinsic(double fx, double fy, double skew) {
        this.pixelError = new NormalizedToPixelError(fx, fy, skew);
    }

    public void setModel(Se3_F64 worldToCamera) {
        this.worldToCamera = worldToCamera;
    }

    public double computeDistance(Point2D3D pt) {
        SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)pt.location, (Point3D_F64)this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        Point2D_F64 p = pt.getObservation();
        return this.pixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
    }

    public void computeDistance(List<Point2D3D> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.computeDistance(observations.get(i));
        }
    }
}

