/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointToPixelTransform_F64;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.distort.PointTransformHomography_F64;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.distort.radtan.LensDistortionRadialTangential;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.distort.PixelTransform2_F64;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.shapes.RectangleLength2D_F32;
import georegression.struct.shapes.RectangleLength2D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class LensDistortionOps {
    public static <T extends ImageBase> ImageDistort<T, T> imageRemoveDistortion(AdjustmentType type, BorderType borderType, CameraPinholeRadial param, CameraPinholeRadial paramAdj, ImageType<T> imageType) {
        boolean skip;
        Class bandType = imageType.getImageClass();
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixelS interp = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)borderType, (Class)bandType);
        Point2Transform2_F32 undistToDist = null;
        switch (type) {
            case EXPAND: 
            case FULL_VIEW: {
                undistToDist = LensDistortionOps.transform_F32(type, param, paramAdj, true);
                break;
            }
            case NONE: {
                undistToDist = LensDistortionOps.transformPoint(param).distort_F32(true, true);
            }
        }
        ImageDistort distort = FactoryDistort.distort((boolean)true, (InterpolatePixel)interp, imageType);
        distort.setModel((PixelTransform2_F32)new PointToPixelTransform_F32(undistToDist));
        distort.setRenderAll(!skip);
        return distort;
    }

    public static Point2Transform2_F32 transform_F32(AdjustmentType type, CameraPinholeRadial param, CameraPinholeRadial paramAdj, boolean undistortedToDistorted) {
        RectangleLength2D_F32 bound;
        Point2Transform2_F32 remove_p_to_p = LensDistortionOps.transformPoint(param).undistort_F32(true, true);
        if (type == AdjustmentType.FULL_VIEW) {
            bound = DistortImageOps.boundBox_F32((int)param.width, (int)param.height, (PixelTransform2_F32)new PointToPixelTransform_F32(remove_p_to_p));
        } else if (type == AdjustmentType.EXPAND) {
            bound = LensDistortionOps.boundBoxInside(param.width, param.height, (PixelTransform2_F32)new PointToPixelTransform_F32(remove_p_to_p));
            LensDistortionOps.roundInside(bound);
        } else {
            throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
        }
        double scaleX = bound.width / (float)param.width;
        double scaleY = bound.height / (float)param.height;
        double scale = type == AdjustmentType.FULL_VIEW ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
        double deltaX = (double)bound.x0 + (scaleX - scale) * (double)param.width / 2.0;
        double deltaY = (double)bound.y0 + (scaleY - scale) * (double)param.height / 2.0;
        DenseMatrix64F A = new DenseMatrix64F(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        return LensDistortionOps.adjustmentTransform_F32(param, paramAdj, undistortedToDistorted, remove_p_to_p, A);
    }

    private static Point2Transform2_F32 adjustmentTransform_F32(CameraPinholeRadial param, CameraPinholeRadial paramAdj, boolean undistToDist, Point2Transform2_F32 remove_p_to_p, DenseMatrix64F A) {
        DenseMatrix64F A_inv = null;
        if (!(undistToDist && paramAdj == null || CommonOps.invert((DenseMatrix64F)A, (DenseMatrix64F)(A_inv = new DenseMatrix64F(3, 3))))) {
            throw new RuntimeException("Failed to invert adjustment matrix.  Probably bad.");
        }
        if (paramAdj != null) {
            PerspectiveOps.adjustIntrinsic(param, A_inv, paramAdj);
        }
        if (undistToDist) {
            Point2Transform2_F32 add_p_to_p = LensDistortionOps.transformPoint(param).distort_F32(true, true);
            PointTransformHomography_F32 adjust = new PointTransformHomography_F32(A);
            return new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{adjust, add_p_to_p});
        }
        PointTransformHomography_F32 adjust = new PointTransformHomography_F32(A_inv);
        return new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{remove_p_to_p, adjust});
    }

    public static Point2Transform2_F64 transform_F64(AdjustmentType type, CameraPinholeRadial param, CameraPinholeRadial paramAdj, boolean undistortedToDistorted) {
        RectangleLength2D_F64 bound;
        Point2Transform2_F64 remove_p_to_p = LensDistortionOps.transformPoint(param).undistort_F64(true, true);
        if (type == AdjustmentType.FULL_VIEW) {
            bound = DistortImageOps.boundBox_F64((int)param.width, (int)param.height, (PixelTransform2_F64)new PointToPixelTransform_F64(remove_p_to_p));
        } else if (type == AdjustmentType.EXPAND) {
            bound = LensDistortionOps.boundBoxInside(param.width, param.height, (PixelTransform2_F64)new PointToPixelTransform_F64(remove_p_to_p));
            LensDistortionOps.roundInside(bound);
        } else {
            throw new IllegalArgumentException("If you don't want to adjust the view just call transformPoint()");
        }
        double scaleX = bound.width / (double)param.width;
        double scaleY = bound.height / (double)param.height;
        double scale = type == AdjustmentType.FULL_VIEW ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
        double deltaX = bound.x0 + (scaleX - scale) * (double)param.width / 2.0;
        double deltaY = bound.y0 + (scaleY - scale) * (double)param.height / 2.0;
        DenseMatrix64F A = new DenseMatrix64F(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        return LensDistortionOps.adjustmentTransform_F64(param, paramAdj, undistortedToDistorted, remove_p_to_p, A);
    }

    private static Point2Transform2_F64 adjustmentTransform_F64(CameraPinholeRadial param, CameraPinholeRadial paramAdj, boolean adjToDistorted, Point2Transform2_F64 remove_p_to_p, DenseMatrix64F A) {
        DenseMatrix64F A_inv = null;
        if (!(adjToDistorted && paramAdj == null || CommonOps.invert((DenseMatrix64F)A, (DenseMatrix64F)(A_inv = new DenseMatrix64F(3, 3))))) {
            throw new RuntimeException("Failed to invert adjustment matrix.  Probably bad.");
        }
        if (paramAdj != null) {
            PerspectiveOps.adjustIntrinsic(param, A_inv, paramAdj);
        }
        if (adjToDistorted) {
            Point2Transform2_F64 add_p_to_p = LensDistortionOps.transformPoint(param).distort_F64(true, true);
            PointTransformHomography_F64 adjust = new PointTransformHomography_F64(A);
            return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{adjust, add_p_to_p});
        }
        PointTransformHomography_F64 adjust = new PointTransformHomography_F64(A_inv);
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{remove_p_to_p, adjust});
    }

    public static LensDistortionNarrowFOV transformPoint(CameraPinholeRadial param) {
        if (param.isDistorted()) {
            return new LensDistortionRadialTangential(param);
        }
        return new LensDistortionPinhole(param);
    }

    public static RectangleLength2D_F32 boundBoxInside(int srcWidth, int srcHeight, PixelTransform2_F32 transform) {
        transform.compute(0, 0);
        float x0 = transform.distX;
        float y0 = transform.distY;
        transform.compute(srcWidth, 0);
        float x1 = transform.distX;
        transform.compute(0, srcHeight);
        float y1 = transform.distY;
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            if (transform.distY > y0) {
                y0 = transform.distY;
            }
            transform.compute(x, srcHeight);
            if (!(transform.distY < y1)) continue;
            y1 = transform.distY;
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            if (transform.distX > x0) {
                x0 = transform.distX;
            }
            transform.compute(srcWidth, y);
            if (!(transform.distX < x1)) continue;
            x1 = transform.distX;
        }
        return new RectangleLength2D_F32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F64 boundBoxInside(int srcWidth, int srcHeight, PixelTransform2_F64 transform) {
        transform.compute(0, 0);
        double x0 = transform.distX;
        double y0 = transform.distY;
        transform.compute(srcWidth, 0);
        double x1 = transform.distX;
        transform.compute(0, srcHeight);
        double y1 = transform.distY;
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            if (transform.distY > y0) {
                y0 = transform.distY;
            }
            transform.compute(x, srcHeight);
            if (!(transform.distY < y1)) continue;
            y1 = transform.distY;
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            if (transform.distX > x0) {
                x0 = transform.distX;
            }
            transform.compute(srcWidth, y);
            if (!(transform.distX < x1)) continue;
            x1 = transform.distX;
        }
        return new RectangleLength2D_F64(x0, y0, x1 - x0, y1 - y0);
    }

    public static void roundInside(RectangleLength2D_F32 bound) {
        float x0 = (float)Math.ceil(bound.x0);
        float y0 = (float)Math.ceil(bound.y0);
        float x1 = (float)Math.floor(bound.x0 + bound.width);
        float y1 = (float)Math.floor(bound.y0 + bound.height);
        bound.x0 = x0;
        bound.y0 = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }

    public static void roundInside(RectangleLength2D_F64 bound) {
        double x0 = Math.ceil(bound.x0);
        double y0 = Math.ceil(bound.y0);
        double x1 = Math.floor(bound.x0 + bound.width);
        double y1 = Math.floor(bound.y0 + bound.height);
        bound.x0 = x0;
        bound.y0 = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }
}

