/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.abst.distort.FDistort;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import org.ejml.data.DenseMatrix64F;

public class RemovePerspectiveDistortion<T extends ImageBase> {
    FDistort distort;
    Estimate1ofEpipolar computeHomography = FactoryMultiView.computeHomography(true);
    DenseMatrix64F H = new DenseMatrix64F(3, 3);
    PointTransformHomography_F32 homography = new PointTransformHomography_F32();
    ArrayList<AssociatedPair> associatedPairs = new ArrayList();
    T output;

    public RemovePerspectiveDistortion(int width, int height, ImageType<T> imageType) {
        this.output = imageType.createImage(width, height);
        this.distort = new FDistort(imageType);
        this.distort.output(this.output);
        this.distort.interp(InterpolationType.BILINEAR).transform((Point2Transform2_F32)this.homography);
        for (int i = 0; i < 4; ++i) {
            this.associatedPairs.add(new AssociatedPair());
        }
        this.associatedPairs.get((int)0).p1.set(0.0, 0.0);
        this.associatedPairs.get((int)1).p1.set((double)(((ImageBase)this.output).width - 1), 0.0);
        this.associatedPairs.get((int)2).p1.set((double)(((ImageBase)this.output).width - 1), (double)(((ImageBase)this.output).height - 1));
        this.associatedPairs.get((int)3).p1.set(0.0, (double)(((ImageBase)this.output).height - 1));
    }

    public boolean apply(T input, Point2D_F64 corner0, Point2D_F64 corner1, Point2D_F64 corner2, Point2D_F64 corner3) {
        this.associatedPairs.get((int)0).p2.set(corner0);
        this.associatedPairs.get((int)1).p2.set(corner1);
        this.associatedPairs.get((int)2).p2.set(corner2);
        this.associatedPairs.get((int)3).p2.set(corner3);
        if (!this.computeHomography.process(this.associatedPairs, this.H)) {
            return false;
        }
        this.homography.set(this.H);
        this.distort.input(input).apply();
        return true;
    }

    public T getOutput() {
        return this.output;
    }
}

