/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F64;
import boofcv.alg.distort.radtan.RemoveRadialNtoN_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.misc.GrlConstants;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class RemoveRadialPtoN_F64
implements Point2Transform2_F64 {
    protected double cx;
    protected double cy;
    protected double fx;
    protected double fy;
    protected double skew;
    protected RadialTangential_F64 params;
    protected DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private double tol = GrlConstants.DCONV_TOL_A;

    public RemoveRadialPtoN_F64() {
    }

    public RemoveRadialPtoN_F64(double tol) {
        this.tol = tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public RemoveRadialPtoN_F64 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, cx);
        this.K_inv.set(1, 2, cy);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        return this;
    }

    public RemoveRadialPtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        out.x = x;
        out.y = y;
        GeometryMath_F64.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F64)out, (GeoTuple2D_F64)out);
        RemoveRadialNtoN_F64.removeRadial(out.x, out.y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }
}

