/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import georegression.geometry.ConvertCoordinates3D_F32;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;

public class EquirectangularTools_F32 {
    int width;
    int height;
    Point2D_F32 temp = new Point2D_F32();

    public void configure(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void equiToNorm(float x, float y, Point3D_F32 norm) {
        this.equiToLonlat(x, y, this.temp);
        ConvertCoordinates3D_F32.latlonToUnitVector((float)this.temp.y, (float)this.temp.x, (GeoTuple3D_F32)norm);
    }

    public void normToEqui(float nx, float ny, float nz, Point2D_F32 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe((double)(-nz), (double)r);
        this.lonlatToEqui((float)lon, (float)lat, rect);
    }

    public void equiToNormFV(float x, float y, Point3D_F32 norm) {
        this.equiToLonlatFV(x, y, this.temp);
        ConvertCoordinates3D_F32.latlonToUnitVector((float)this.temp.y, (float)this.temp.x, (GeoTuple3D_F32)norm);
    }

    public void normToEquiFV(float nx, float ny, float nz, Point2D_F32 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe((double)(-nz), (double)r);
        this.lonlatToEquiFV((float)lon, (float)lat, rect);
    }

    public void equiToLonlat(float x, float y, Point2D_F32 lonlat) {
        lonlat.x = (x / (float)this.width - 0.5f) * GrlConstants.F_PI2;
        lonlat.y = (y / (float)(this.height - 1) - 0.5f) * GrlConstants.F_PI;
    }

    public void equiToLonlatFV(float x, float y, Point2D_F32 lonlat) {
        lonlat.x = (x / (float)this.width - 0.5f) * GrlConstants.F_PI2;
        lonlat.y = (((float)this.height - y - 1.0f) / (float)(this.height - 1) - 0.5f) * GrlConstants.F_PI;
    }

    public void lonlatToEqui(float lon, float lat, Point2D_F32 rect) {
        rect.x = UtilAngle.wrapZeroToOne((float)(lon / GrlConstants.F_PI2 + 0.5f)) * (float)this.width;
        rect.y = UtilAngle.reflectZeroToOne((float)(lat / GrlConstants.F_PI + 0.5f)) * (float)(this.height - 1);
    }

    public void lonlatToEquiFV(float lon, float lat, Point2D_F32 rect) {
        rect.x = UtilAngle.wrapZeroToOne((float)(lon / GrlConstants.F_PI2 + 0.5f)) * (float)this.width;
        rect.y = UtilAngle.reflectZeroToOne((float)(lat / GrlConstants.F_PI + 0.5f)) * (float)(this.height - 1);
        rect.y = (float)this.height - rect.y - 1.0f;
    }
}

