/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import georegression.geometry.ConvertCoordinates3D_F64;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public class EquirectangularTools_F64 {
    int width;
    int height;
    Point2D_F64 temp = new Point2D_F64();

    public void configure(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void equiToNorm(double x, double y, Point3D_F64 norm) {
        this.equiToLonlat(x, y, this.temp);
        ConvertCoordinates3D_F64.latlonToUnitVector((double)this.temp.y, (double)this.temp.x, (GeoTuple3D_F64)norm);
    }

    public void normToEqui(double nx, double ny, double nz, Point2D_F64 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe((double)(-nz), (double)r);
        this.lonlatToEqui(lon, lat, rect);
    }

    public void equiToNormFV(double x, double y, Point3D_F64 norm) {
        this.equiToLonlatFV(x, y, this.temp);
        ConvertCoordinates3D_F64.latlonToUnitVector((double)this.temp.y, (double)this.temp.x, (GeoTuple3D_F64)norm);
    }

    public void normToEquiFV(double nx, double ny, double nz, Point2D_F64 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe((double)(-nz), (double)r);
        this.lonlatToEquiFV(lon, lat, rect);
    }

    public void equiToLonlat(double x, double y, Point2D_F64 lonlat) {
        lonlat.x = (x / (double)this.width - 0.5) * GrlConstants.PI2;
        lonlat.y = (y / (double)(this.height - 1) - 0.5) * GrlConstants.PI;
    }

    public void equiToLonlatFV(double x, double y, Point2D_F64 lonlat) {
        lonlat.x = (x / (double)this.width - 0.5) * GrlConstants.PI2;
        lonlat.y = (((double)this.height - y - 1.0) / (double)(this.height - 1) - 0.5) * GrlConstants.PI;
    }

    public void lonlatToEqui(double lon, double lat, Point2D_F64 rect) {
        rect.x = UtilAngle.wrapZeroToOne((double)(lon / GrlConstants.PI2 + 0.5)) * (double)this.width;
        rect.y = UtilAngle.reflectZeroToOne((double)(lat / GrlConstants.PI + 0.5)) * (double)(this.height - 1);
    }

    public void lonlatToEquiFV(double lon, double lat, Point2D_F64 rect) {
        rect.x = UtilAngle.wrapZeroToOne((double)(lon / GrlConstants.PI2 + 0.5)) * (double)this.width;
        rect.y = UtilAngle.reflectZeroToOne((double)(lat / GrlConstants.PI + 0.5)) * (double)(this.height - 1);
        rect.y = (double)this.height - rect.y - 1.0;
    }
}

