/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.universal;

import boofcv.alg.distort.radtan.RadialTangential_F64;
import boofcv.alg.distort.radtan.RemoveRadialNtoN_F64;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.Point2Transform3_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.misc.GrlConstants;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class UniOmniPtoS_F64
implements Point2Transform3_F64 {
    double mirrorOffset;
    protected RadialTangential_F64 distortion = new RadialTangential_F64();
    private Point2D_F64 p2 = new Point2D_F64();
    private double tol = GrlConstants.DCONV_TOL_A;
    protected DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);

    public UniOmniPtoS_F64(CameraUniversalOmni model) {
        this.setModel(model);
    }

    public UniOmniPtoS_F64() {
    }

    public double getTol() {
        return this.tol;
    }

    public void setTol(double tol) {
        this.tol = tol;
    }

    public void setModel(CameraUniversalOmni model) {
        this.mirrorOffset = model.mirrorOffset;
        this.distortion.set(model.radial, model.t1, model.t2);
        this.K_inv.set(0, 0, model.fx);
        this.K_inv.set(1, 1, model.fy);
        this.K_inv.set(0, 1, model.skew);
        this.K_inv.set(0, 2, model.cx);
        this.K_inv.set(1, 2, model.cy);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
    }

    public void compute(double x, double y, Point3D_F64 out) {
        this.p2.x = x;
        this.p2.y = y;
        GeometryMath_F64.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F64)this.p2, (GeoTuple2D_F64)this.p2);
        RemoveRadialNtoN_F64.removeRadial(this.p2.x, this.p2.y, this.distortion.radial, this.distortion.t1, this.distortion.t2, this.p2, this.tol);
        double u = this.p2.x;
        double v = this.p2.y;
        double xi = this.mirrorOffset;
        double a = u * u + v * v + 1.0;
        double b = -2.0 * xi;
        double c = xi * xi - 1.0;
        double t = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        out.x = u * t;
        out.y = v * t;
        out.z = t - xi;
    }
}

