/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.distort.PointTransformHomography_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.alg.geo.rectify.RectifyFundamental;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.shapes.RectangleLength2D_F32;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class RectifyImageOps {
    public static RectifyCalibrated createCalibrated() {
        return new RectifyCalibrated();
    }

    public static RectifyFundamental createUncalibrated() {
        return new RectifyFundamental();
    }

    public static void fullViewLeft(CameraPinholeRadial paramLeft, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, DenseMatrix64F rectifyK) {
        paramLeft = new CameraPinholeRadial(paramLeft);
        Point2Transform2_F32 tranLeft = RectifyImageOps.transformPixelToRect_F32(paramLeft, rectifyLeft);
        RectangleLength2D_F32 bound = DistortImageOps.boundBox_F32((int)paramLeft.width, (int)paramLeft.height, (PixelTransform2_F32)new PointToPixelTransform_F32(tranLeft));
        double scaleX = (float)paramLeft.width / bound.width;
        double scaleY = (float)paramLeft.height / bound.height;
        double scale = Math.min(scaleX, scaleY);
        RectifyImageOps.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight) {
        PointTransformHomography_F32 tranLeft = new PointTransformHomography_F32(rectifyLeft);
        RectangleLength2D_F32 bound = DistortImageOps.boundBox_F32((int)imageWidth, (int)imageHeight, (PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)tranLeft));
        double scaleX = (float)imageWidth / bound.width;
        double scaleY = (float)imageHeight / bound.height;
        double scale = Math.min(scaleX, scaleY);
        RectifyImageOps.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    public static void allInsideLeft(CameraPinholeRadial paramLeft, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, DenseMatrix64F rectifyK) {
        paramLeft = new CameraPinholeRadial(paramLeft);
        Point2Transform2_F32 tranLeft = RectifyImageOps.transformPixelToRect_F32(paramLeft, rectifyLeft);
        RectangleLength2D_F32 bound = LensDistortionOps.boundBoxInside(paramLeft.width, paramLeft.height, (PixelTransform2_F32)new PointToPixelTransform_F32(tranLeft));
        LensDistortionOps.roundInside(bound);
        double scaleX = (double)paramLeft.width / (double)bound.width;
        double scaleY = (double)paramLeft.height / (double)bound.height;
        double scale = Math.max(scaleX, scaleY);
        RectifyImageOps.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight) {
        PointTransformHomography_F32 tranLeft = new PointTransformHomography_F32(rectifyLeft);
        RectangleLength2D_F32 bound = LensDistortionOps.boundBoxInside(imageWidth, imageHeight, (PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)tranLeft));
        double scaleX = (double)imageWidth / (double)bound.width;
        double scaleY = (double)imageHeight / (double)bound.height;
        double scale = Math.max(scaleX, scaleY);
        RectifyImageOps.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    private static void adjustCalibrated(DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, DenseMatrix64F rectifyK, RectangleLength2D_F32 bound, double scale) {
        double deltaX = (double)(-bound.x0) * scale;
        double deltaY = (double)(-bound.y0) * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        SimpleMatrix rL = SimpleMatrix.wrap((DenseMatrix64F)rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap((DenseMatrix64F)rectifyRight);
        SimpleMatrix K = SimpleMatrix.wrap((DenseMatrix64F)rectifyK);
        SimpleMatrix K_inv = (SimpleMatrix)K.invert();
        rL = (SimpleMatrix)K_inv.mult((SimpleBase)rL);
        rR = (SimpleMatrix)K_inv.mult((SimpleBase)rR);
        K = (SimpleMatrix)A.mult((SimpleBase)K);
        rectifyK.set((D1Matrix64F)K.getMatrix());
        rectifyLeft.set((D1Matrix64F)((SimpleMatrix)K.mult((SimpleBase)rL)).getMatrix());
        rectifyRight.set((D1Matrix64F)((SimpleMatrix)K.mult((SimpleBase)rR)).getMatrix());
    }

    private static void adjustUncalibrated(DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, RectangleLength2D_F32 bound, double scale) {
        double deltaX = (double)(-bound.x0) * scale;
        double deltaY = (double)(-bound.y0) * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        SimpleMatrix rL = SimpleMatrix.wrap((DenseMatrix64F)rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap((DenseMatrix64F)rectifyRight);
        rectifyLeft.set((D1Matrix64F)((SimpleMatrix)A.mult((SimpleBase)rL)).getMatrix());
        rectifyRight.set((D1Matrix64F)((SimpleMatrix)A.mult((SimpleBase)rR)).getMatrix());
    }

    public static Point2Transform2_F32 transformRectToPixel_F32(CameraPinholeRadial param, DenseMatrix64F rectify) {
        Point2Transform2_F32 add_p_to_p = LensDistortionOps.transformPoint(param).distort_F32(true, true);
        DenseMatrix64F rectifyInv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)rectify, (DenseMatrix64F)rectifyInv);
        PointTransformHomography_F32 removeRect = new PointTransformHomography_F32(rectifyInv);
        return new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{removeRect, add_p_to_p});
    }

    public static Point2Transform2_F64 transformRectToPixel_F64(CameraPinholeRadial param, DenseMatrix64F rectify) {
        Point2Transform2_F64 add_p_to_p = LensDistortionOps.transformPoint(param).distort_F64(true, true);
        DenseMatrix64F rectifyInv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)rectify, (DenseMatrix64F)rectifyInv);
        PointTransformHomography_F64 removeRect = new PointTransformHomography_F64(rectifyInv);
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{removeRect, add_p_to_p});
    }

    public static Point2Transform2_F32 transformPixelToRect_F32(CameraPinholeRadial param, DenseMatrix64F rectify) {
        Point2Transform2_F32 remove_p_to_p = LensDistortionOps.transformPoint(param).undistort_F32(true, true);
        PointTransformHomography_F32 rectifyPixel = new PointTransformHomography_F32(rectify);
        return new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{remove_p_to_p, rectifyPixel});
    }

    public static Point2Transform2_F64 transformPixelToRect_F64(CameraPinholeRadial param, DenseMatrix64F rectify) {
        Point2Transform2_F64 remove_p_to_p = LensDistortionOps.transformPoint(param).undistort_F64(true, true);
        PointTransformHomography_F64 rectifyDistort = new PointTransformHomography_F64(rectify);
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{remove_p_to_p, rectifyDistort});
    }

    public static Point2Transform2_F64 transformPixelToRectNorm_F64(CameraPinholeRadial param, DenseMatrix64F rectify, DenseMatrix64F rectifyK) {
        if (rectifyK.get(0, 1) != 0.0) {
            throw new IllegalArgumentException("Skew should be zero in rectified images");
        }
        Point2Transform2_F64 remove_p_to_p = LensDistortionOps.transformPoint(param).undistort_F64(true, true);
        PointTransformHomography_F64 rectifyDistort = new PointTransformHomography_F64(rectify);
        PinholePtoN_F64 pixelToNorm = new PinholePtoN_F64();
        pixelToNorm.set(rectifyK.get(0, 0), rectifyK.get(1, 1), rectifyK.get(0, 1), rectifyK.get(0, 2), rectifyK.get(1, 2));
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{remove_p_to_p, rectifyDistort, pixelToNorm});
    }

    public static <T extends ImageGray> ImageDistort<T, T> rectifyImage(DenseMatrix64F rectify, BorderType borderType, Class<T> imageType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)borderType);
        DenseMatrix64F rectifyInv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)rectify, (DenseMatrix64F)rectifyInv);
        PointTransformHomography_F32 rectifyTran = new PointTransformHomography_F32(rectifyInv);
        ImageDistort ret = FactoryDistort.distortSB((boolean)false, (InterpolatePixelS)interp, imageType);
        ret.setRenderAll(!skip);
        ret.setModel((PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)rectifyTran));
        return ret;
    }

    public static <T extends ImageBase> ImageDistort<T, T> rectifyImage(CameraPinholeRadial param, DenseMatrix64F rectify, BorderType borderType, ImageType<T> imageType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixel interp = FactoryInterpolation.createPixel((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)borderType, imageType);
        ImageDistort ret = FactoryDistort.distort((boolean)true, (InterpolatePixel)interp, imageType);
        ret.setRenderAll(!skip);
        Point2Transform2_F32 transform = RectifyImageOps.transformRectToPixel_F32(param, rectify);
        ret.setModel((PixelTransform2_F32)new PointToPixelTransform_F32(transform));
        return ret;
    }
}

