/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraPinhole;
import java.io.Serializable;

public class CameraPinholeRadial
extends CameraPinhole
implements Serializable {
    public double[] radial;
    public double t1;
    public double t2;

    public CameraPinholeRadial() {
    }

    public CameraPinholeRadial(CameraPinholeRadial param) {
        this.set(param);
    }

    public CameraPinholeRadial(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    @Override
    public CameraPinholeRadial fsetK(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        return (CameraPinholeRadial)super.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    public CameraPinholeRadial fsetRadial(double ... radial) {
        this.radial = (double[])radial.clone();
        return this;
    }

    public CameraPinholeRadial fsetTangental(double t1, double t2) {
        this.t1 = t1;
        this.t2 = t2;
        return this;
    }

    public void set(CameraPinholeRadial param) {
        super.set(param);
        if (param.radial != null) {
            this.radial = (double[])param.radial.clone();
        }
        this.t1 = param.t1;
        this.t2 = param.t2;
    }

    public boolean isDistorted() {
        if (this.radial != null && this.radial.length > 0) {
            for (int i = 0; i < this.radial.length; ++i) {
                if (this.radial[i] == 0.0) continue;
                return true;
            }
        }
        return this.t1 != 0.0 || this.t2 != 0.0;
    }

    public double[] getRadial() {
        return this.radial;
    }

    public void setRadial(double ... radial) {
        this.radial = radial;
    }

    public double getT1() {
        return this.t1;
    }

    public void setT1(double t1) {
        this.t1 = t1;
    }

    public double getT2() {
        return this.t2;
    }

    public void setT2(double t2) {
        this.t2 = t2;
    }

    @Override
    public void print() {
        super.print();
        if (this.radial != null) {
            for (int i = 0; i < this.radial.length; ++i) {
                System.out.printf("radial[%d] = %6.2e\n", i, this.radial[i]);
            }
        } else {
            System.out.println("No radial");
        }
        if (this.t1 != 0.0 && this.t2 != 0.0) {
            System.out.printf("tangential = ( %6.2e , %6.2e)\n", this.t1, this.t2);
        } else {
            System.out.println("No tangential");
        }
    }
}

