/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F32;

public abstract class ImageDistortCache<T extends ImageSingleBand>
implements ImageDistort<T> {
    private int width = -1;
    private int height = -1;
    private Point2D_F32[] map;
    private InterpolatePixelS<T> interp;
    private ImageBorder<T> border;
    private PixelTransform_F32 dstToSrc;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    protected T srcImg;
    protected T dstImg;
    protected boolean dirty;

    public ImageDistortCache(InterpolatePixelS<T> interp, ImageBorder<T> border) {
        this.interp = interp;
        this.border = border;
    }

    @Override
    public void setModel(PixelTransform_F32 dstToSrc) {
        this.dirty = true;
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(T srcImg, T dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageSingleBand)dstImg).width;
        this.y1 = ((ImageSingleBand)dstImg).height;
        if (this.border != null) {
            this.applyBorder();
        } else {
            this.applyNoBorder();
        }
    }

    @Override
    public void apply(T srcImg, T dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.border != null) {
            this.applyBorder();
        } else {
            this.applyNoBorder();
        }
    }

    private void init(T srcImg, T dstImg) {
        if (this.dirty || this.width != ((ImageSingleBand)dstImg).width || this.height != ((ImageSingleBand)dstImg).height) {
            this.width = ((ImageSingleBand)dstImg).width;
            this.height = ((ImageSingleBand)dstImg).height;
            this.map = new Point2D_F32[this.width * this.height];
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = new Point2D_F32();
            }
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.dstToSrc.compute(x, y);
                    this.map[index++].set(this.dstToSrc.distX, this.dstToSrc.distY);
                }
            }
        } else if (((ImageSingleBand)dstImg).width != this.width || ((ImageSingleBand)dstImg).height != this.height) {
            throw new IllegalArgumentException("Unexpected dstImg dimension");
        }
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
    }

    public void applyBorder() {
        this.border.setImage(this.srcImg);
        float minInterpX = this.interp.getFastBorderX();
        float minInterpY = this.interp.getFastBorderY();
        float maxInterpX = ((ImageBase)this.srcImg).getWidth() - this.interp.getFastBorderX() - 1;
        float maxInterpY = ((ImageBase)this.srcImg).getHeight() - this.interp.getFastBorderY() - 1;
        float widthF = ((ImageBase)this.srcImg).getWidth() - 1;
        float heightF = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                if (s.x < minInterpX || s.x > maxInterpX || s.y < minInterpY || s.y > maxInterpY) {
                    if (s.x < 0.0f || s.x > widthF || s.y < 0.0f || s.y > heightF) {
                        this.assign(indexDst, (float)this.border.getGeneral((int)s.x, (int)s.y));
                    } else {
                        this.assign(indexDst, this.interp.get(s.x, s.y));
                    }
                } else {
                    this.assign(indexDst, this.interp.get_fast(s.x, s.y));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    public void applyNoBorder() {
        float minInterpX = this.interp.getFastBorderX();
        float minInterpY = this.interp.getFastBorderY();
        float maxInterpX = ((ImageBase)this.srcImg).getWidth() - this.interp.getFastBorderX() - 1;
        float maxInterpY = ((ImageBase)this.srcImg).getHeight() - this.interp.getFastBorderY() - 1;
        float widthF = ((ImageBase)this.srcImg).getWidth() - 1;
        float heightF = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                if (s.x < minInterpX || s.x > maxInterpX || s.y < minInterpY || s.y > maxInterpY) {
                    if (s.x >= 0.0f && s.x <= widthF && s.y >= 0.0f && s.y <= heightF) {
                        this.assign(indexDst, this.interp.get(s.x, s.y));
                    }
                } else {
                    this.assign(indexDst, this.interp.get_fast(s.x, s.y));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    protected abstract void assign(int var1, float var2);
}

