/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner;
import boofcv.alg.filter.blur.impl.ImplMedianSortEdgeNaive;
import boofcv.alg.filter.blur.impl.ImplMedianSortNaive;
import boofcv.alg.filter.convolve.ConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class BlurImageOps {
    public static ImageUInt8 mean(ImageUInt8 input, ImageUInt8 output, int radius, ImageUInt8 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        ConvolveImageMean.horizontal(input, storage, radius);
        ConvolveImageMean.vertical(storage, output, radius);
        return output;
    }

    public static ImageUInt8 median(ImageUInt8 input, ImageUInt8 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        int w = radius * 2 + 1;
        int[] offset = new int[w * w];
        int[] histogram = new int[256];
        ImplMedianHistogramInner.process(input, output, radius, offset, histogram);
        ImplMedianSortEdgeNaive.process(input, output, radius, offset);
        return output;
    }

    public static ImageUInt8 gaussian(ImageUInt8 input, ImageUInt8 output, double sigma, int radius, ImageUInt8 storage) {
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        Kernel1D_I32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_I32.class, sigma, radius);
        ConvolveNormalized.horizontal(kernel, input, storage);
        ConvolveNormalized.vertical(kernel, storage, output);
        return output;
    }

    public static ImageFloat32 mean(ImageFloat32 input, ImageFloat32 output, int radius, ImageFloat32 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        ConvolveImageMean.horizontal(input, storage, radius);
        ConvolveImageMean.vertical(storage, output, radius);
        return output;
    }

    public static ImageFloat32 median(ImageFloat32 input, ImageFloat32 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        ImplMedianSortNaive.process(input, output, radius, null);
        return output;
    }

    public static ImageFloat32 gaussian(ImageFloat32 input, ImageFloat32 output, double sigma, int radius, ImageFloat32 storage) {
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        Kernel1D_F32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigma, radius);
        ConvolveNormalized.horizontal(kernel, input, storage);
        ConvolveNormalized.vertical(kernel, storage, output);
        return output;
    }

    public static <T extends ImageSingleBand> MultiSpectral<T> mean(MultiSpectral<T> input, MultiSpectral<T> output, int radius, T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getType(), input.width, input.height);
        }
        if (output == null) {
            output = input._createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), ((MultiSpectral)output).getBand(band), radius);
        }
        return output;
    }

    public static <T extends ImageSingleBand> MultiSpectral<T> median(MultiSpectral<T> input, MultiSpectral<T> output, int radius) {
        if (output == null) {
            output = input._createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), ((MultiSpectral)output).getBand(band), radius);
        }
        return output;
    }

    public static <T extends ImageSingleBand> MultiSpectral<T> gaussian(MultiSpectral<T> input, MultiSpectral<T> output, double sigma, int radius, T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getType(), input.width, input.height);
        }
        if (output == null) {
            output = input._createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.gaussian(input.getBand(band), ((MultiSpectral)output).getBand(band), sigma, radius, storage);
        }
        return output;
    }
}

