/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.down;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ConvolveDownNormalizedNaive {
    public static void horizontal(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width - input.width % skip;
        int height = input.height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += skip) {
                float total = 0.0f;
                float div = 0.0f;
                int startX = x - radius;
                int endX = x + radius;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= input.width) {
                    endX = input.width - 1;
                }
                for (int j = startX; j <= endX; ++j) {
                    float v = kernel.get(j - x + radius);
                    total += input.get(j, y) * v;
                    div += v;
                }
                output.set(x / skip, y, total / div);
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width;
        int height = input.height - input.height % skip;
        for (int y = 0; y < height; y += skip) {
            for (int x = 0; x < width; ++x) {
                float total = 0.0f;
                float div = 0.0f;
                int startY = y - radius;
                int endY = y + radius;
                if (startY < 0) {
                    startY = 0;
                }
                if (endY >= input.height) {
                    endY = input.height - 1;
                }
                for (int i = startY; i <= endY; ++i) {
                    float v = kernel.get(i - y + radius);
                    total += input.get(x, i) * v;
                    div += v;
                }
                output.set(x, y / skip, total / div);
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width - input.width % skip;
        int height = input.height - input.height % skip;
        for (int y = 0; y < height; y += skip) {
            for (int x = 0; x < width; x += skip) {
                int startX = x - radius;
                int endX = x + radius;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= input.width) {
                    endX = input.width - 1;
                }
                int startY = y - radius;
                int endY = y + radius;
                if (startY < 0) {
                    startY = 0;
                }
                if (endY >= input.height) {
                    endY = input.height - 1;
                }
                float total = 0.0f;
                float div = 0.0f;
                for (int i = startY; i <= endY; ++i) {
                    for (int j = startX; j <= endX; ++j) {
                        float v = kernel.get(j - x + radius, i - y + radius);
                        total += input.get(j, i) * v;
                        div += v;
                    }
                }
                output.set(x / skip, y / skip, total / div);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width - input.width % skip;
        int height = input.height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += skip) {
                int total = 0;
                int div = 0;
                int startX = x - radius;
                int endX = x + radius;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= input.width) {
                    endX = input.width - 1;
                }
                for (int j = startX; j <= endX; ++j) {
                    int v = kernel.get(j - x + radius);
                    total += input.get(j, y) * v;
                    div += v;
                }
                output.set(x / skip, y, (total + div / 2) / div);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width;
        int height = input.height - input.height % skip;
        for (int y = 0; y < height; y += skip) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int div = 0;
                int startY = y - radius;
                int endY = y + radius;
                if (startY < 0) {
                    startY = 0;
                }
                if (endY >= input.height) {
                    endY = input.height - 1;
                }
                for (int i = startY; i <= endY; ++i) {
                    int v = kernel.get(i - y + radius);
                    total += input.get(x, i) * v;
                    div += v;
                }
                output.set(x, y / skip, (total + div / 2) / div);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width - input.width % skip;
        int height = input.height - input.height % skip;
        for (int y = 0; y < height; y += skip) {
            for (int x = 0; x < width; x += skip) {
                int startX = x - radius;
                int endX = x + radius;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= input.width) {
                    endX = input.width - 1;
                }
                int startY = y - radius;
                int endY = y + radius;
                if (startY < 0) {
                    startY = 0;
                }
                if (endY >= input.height) {
                    endY = input.height - 1;
                }
                int total = 0;
                int div = 0;
                for (int i = startY; i <= endY; ++i) {
                    for (int j = startX; j <= endX; ++j) {
                        int v = kernel.get(j - x + radius, i - y + radius);
                        total += input.get(j, i) * v;
                        div += v;
                    }
                }
                output.set(x / skip, y / skip, (total + div / 2) / div);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width - input.width % skip;
        int height = input.height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += skip) {
                int total = 0;
                int div = 0;
                int startX = x - radius;
                int endX = x + radius;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= input.width) {
                    endX = input.width - 1;
                }
                for (int j = startX; j <= endX; ++j) {
                    int v = kernel.get(j - x + radius);
                    total += input.get(j, y) * v;
                    div += v;
                }
                output.set(x / skip, y, (total + div / 2) / div);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width;
        int height = input.height - input.height % skip;
        for (int y = 0; y < height; y += skip) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int div = 0;
                int startY = y - radius;
                int endY = y + radius;
                if (startY < 0) {
                    startY = 0;
                }
                if (endY >= input.height) {
                    endY = input.height - 1;
                }
                for (int i = startY; i <= endY; ++i) {
                    int v = kernel.get(i - y + radius);
                    total += input.get(x, i) * v;
                    div += v;
                }
                output.set(x, y / skip, (total + div / 2) / div);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        int radius = kernel.getRadius();
        int width = input.width - input.width % skip;
        int height = input.height - input.height % skip;
        for (int y = 0; y < height; y += skip) {
            for (int x = 0; x < width; x += skip) {
                int startX = x - radius;
                int endX = x + radius;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= input.width) {
                    endX = input.width - 1;
                }
                int startY = y - radius;
                int endY = y + radius;
                if (startY < 0) {
                    startY = 0;
                }
                if (endY >= input.height) {
                    endY = input.height - 1;
                }
                int total = 0;
                int div = 0;
                for (int i = startY; i <= endY; ++i) {
                    for (int j = startX; j <= endX; ++j) {
                        int v = kernel.get(j - x + radius, i - y + radius);
                        total += input.get(j, i) * v;
                        div += v;
                    }
                }
                output.set(x / skip, y / skip, (total + div / 2) / div);
            }
        }
    }
}

