/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.ConvolveWithBorder;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.core.image.border.ImageBorder1D_F32;
import boofcv.core.image.border.ImageBorder1D_I32;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;

public class HessianFromGradient {
    public static void hessianPrewitt(ImageSInt16 inputDerivX, ImageSInt16 inputDerivY, ImageSInt16 derivXX, ImageSInt16 derivYY, ImageSInt16 derivXY, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientPrewitt.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientPrewitt.kernelDerivY_I32, inputDerivY, (ImageInt16)derivYY, border);
        } else {
            ConvolveImageNoBorder.convolve(GradientPrewitt.kernelDerivY_I32, inputDerivY, (ImageInt16)derivYY);
        }
    }

    public static void hessianPrewitt(ImageFloat32 inputDerivX, ImageFloat32 inputDerivY, ImageFloat32 derivXX, ImageFloat32 derivYY, ImageFloat32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientPrewitt.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientPrewitt.kernelDerivY_F32, inputDerivY, derivYY, border);
        } else {
            ConvolveImageNoBorder.convolve(GradientPrewitt.kernelDerivY_F32, inputDerivY, derivYY);
        }
    }

    public static void hessianSobel(ImageSInt16 inputDerivX, ImageSInt16 inputDerivY, ImageSInt16 derivXX, ImageSInt16 derivYY, ImageSInt16 derivXY, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientSobel.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientSobel.kernelDerivY_I32, inputDerivY, (ImageInt16)derivYY, new ImageBorder1D_I32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.convolve(GradientSobel.kernelDerivY_I32, inputDerivY, (ImageInt16)derivYY);
        }
    }

    public static void hessianSobel(ImageFloat32 inputDerivX, ImageFloat32 inputDerivY, ImageFloat32 derivXX, ImageFloat32 derivYY, ImageFloat32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientSobel.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientSobel.kernelDerivY_F32, inputDerivY, derivYY, new ImageBorder1D_F32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.convolve(GradientSobel.kernelDerivY_F32, inputDerivY, derivYY);
        }
    }

    public static void hessianThree(ImageSInt16 inputDerivX, ImageSInt16 inputDerivY, ImageSInt16 derivXX, ImageSInt16 derivYY, ImageSInt16 derivXY, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientThree.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.vertical(GradientThree.kernelDeriv_I32, inputDerivY, (ImageInt16)derivYY, new ImageBorder1D_I32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.vertical(GradientThree.kernelDeriv_I32, inputDerivY, (ImageInt16)derivYY);
        }
    }

    public static void hessianThree(ImageFloat32 inputDerivX, ImageFloat32 inputDerivY, ImageFloat32 derivXX, ImageFloat32 derivYY, ImageFloat32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientThree.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.vertical(GradientThree.kernelDeriv_F32, inputDerivY, derivYY, new ImageBorder1D_F32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.vertical(GradientThree.kernelDeriv_F32, inputDerivY, derivYY);
        }
    }
}

