/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.MultiSpectral;
import java.util.Random;

public class GImageMiscOps {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, ImageBase input, ImageBase output) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageInt8)input, (ImageInt8)output);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageInt16)input, (ImageInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageSInt32)input, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageSInt64)input, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageFloat32)input, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageFloat64)input, (ImageFloat64)output);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral mi = (MultiSpectral)input;
            MultiSpectral mo = (MultiSpectral)output;
            for (int i = 0; i < mi.getNumBands(); ++i) {
                GImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, mi.getBand(i), mo.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fill(ImageBase input, double value) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((ImageInt8)input, (int)value);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((ImageInt16)input, (int)value);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fill((ImageSInt32)input, (int)value);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fill((ImageSInt64)input, (long)value);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fill((ImageFloat32)input, (float)value);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((ImageFloat64)input, value);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI8)input, (int)value);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI16)input, (int)value);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS32)input, (int)value);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS64)input, (long)value);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedF32)input, (float)value);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((InterleavedF64)input, value);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fill(m.getBand(i), value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillBorder(ImageBase input, double value, int radius) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBorder((ImageInt8)input, (int)value, radius);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBorder((ImageInt16)input, (int)value, radius);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillBorder((ImageSInt32)input, (int)value, radius);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillBorder((ImageSInt64)input, (long)value, radius);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillBorder((ImageFloat32)input, (float)value, radius);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillBorder((ImageFloat64)input, value, radius);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillBorder(m.getBand(i), value, radius);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillRectangle(ImageBase input, double value, int x0, int y0, int width, int height) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((ImageInt8)input, (int)value, x0, y0, width, height);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((ImageInt16)input, (int)value, x0, y0, width, height);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((ImageSInt32)input, (int)value, x0, y0, width, height);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillRectangle((ImageSInt64)input, (long)value, x0, y0, width, height);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((ImageFloat32)input, (float)value, x0, y0, width, height);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillRectangle((ImageFloat64)input, value, x0, y0, width, height);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillRectangle(m.getBand(i), value, x0, y0, width, height);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillGaussian(ImageBase input, Random rand, double mean, double sigma, double lowerBound, double upperBound) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((ImageInt8)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((ImageInt16)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((ImageSInt32)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillGaussian((ImageSInt64)input, rand, mean, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((ImageFloat32)input, rand, mean, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillGaussian((ImageFloat64)input, rand, mean, sigma, lowerBound, upperBound);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillUniform(ImageBase input, Random rand, double min, double max) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((ImageInt8)input, rand, (int)min, (int)max - 1);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((ImageInt16)input, rand, (int)min, (int)max - 1);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillUniform((ImageSInt32)input, rand, (int)min, (int)max - 1);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillUniform((ImageSInt64)input, rand, (long)min, (long)max - 1L);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillUniform((ImageFloat32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillUniform((ImageFloat64)input, rand, min, max);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((InterleavedI8)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((InterleavedI16)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedS32)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedS64)input, rand, (long)min, (long)max - 1L);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillUniform((InterleavedF64)input, rand, min, max);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillUniform(m.getBand(i), rand, min, max);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addGaussian(ImageBase input, Random rand, double sigma, double lowerBound, double upperBound) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageUInt8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageUInt16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt32)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt64)input, rand, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageFloat32)input, rand, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addGaussian((ImageFloat64)input, rand, sigma, lowerBound, upperBound);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.addGaussian(m.getBand(i), rand, sigma, lowerBound, upperBound);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addUniform(ImageBase input, Random rand, double min, double max) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageUInt8)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt8)input, rand, (int)min, (int)max);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageUInt16)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt16)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt32)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt64)input, rand, (long)min, (long)max);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageFloat32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addUniform((ImageFloat64)input, rand, min, max);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.addUniform(m.getBand(i), rand, min, max);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void flipVertical(ImageBase img) {
        if (img instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageInt8)img);
                return;
            } else if (ImageInt16.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageInt16)img);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageSInt32)img);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageSInt64)img);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageFloat32)img);
                return;
            } else {
                if (!ImageFloat64.class.isAssignableFrom(img.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ImageMiscOps.flipVertical((ImageFloat64)img);
            }
            return;
        } else {
            if (!(img instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + img.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)img;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.flipVertical(m.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void flipHorizontal(ImageBase img) {
        if (img instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageInt8)img);
                return;
            } else if (ImageInt16.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageInt16)img);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageSInt32)img);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageSInt64)img);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageFloat32)img);
                return;
            } else {
                if (!ImageFloat64.class.isAssignableFrom(img.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ImageMiscOps.flipHorizontal((ImageFloat64)img);
            }
            return;
        } else {
            if (!(img instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + img.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)img;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.flipHorizontal(m.getBand(i));
            }
        }
    }
}

