/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.alg.filter.convolve.noborder.ImplConvolveMean;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalized_JustBorder;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ConvolveImageMean {
    public static void horizontal(ImageFloat32 input, ImageFloat32 output, int radius) {
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, true);
        if (kernel.width > input.width) {
            ConvolveNormalized.horizontal(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.horizontal(kernel, input, output);
            ImplConvolveMean.horizontal(input, output, radius);
        }
    }

    public static void vertical(ImageFloat32 input, ImageFloat32 output, int radius) {
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, true);
        if (kernel.width > input.height) {
            ConvolveNormalized.vertical(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.vertical(kernel, input, output);
            ImplConvolveMean.vertical(input, output, radius);
        }
    }

    public static void horizontal(ImageUInt8 input, ImageUInt8 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.width) {
            ConvolveNormalized.horizontal(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.horizontal(kernel, input, output);
            ImplConvolveMean.horizontal(input, output, radius);
        }
    }

    public static void vertical(ImageUInt8 input, ImageInt8 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.height) {
            ConvolveNormalized.vertical(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.vertical(kernel, input, output);
            ImplConvolveMean.vertical(input, output, radius);
        }
    }

    public static void horizontal(ImageSInt16 input, ImageInt16 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.width) {
            ConvolveNormalized.horizontal(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.horizontal(kernel, input, output);
            ImplConvolveMean.horizontal(input, output, radius);
        }
    }

    public static void vertical(ImageSInt16 input, ImageInt16 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.height) {
            ConvolveNormalized.vertical(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.vertical(kernel, input, output);
            ImplConvolveMean.vertical(input, output, radius);
        }
    }
}

