/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class HessianThree_Standard {
    public static void process(ImageFloat32 orig, ImageFloat32 derivXX, ImageFloat32 derivYY, ImageFloat32 derivXY) {
        float[] data = orig.data;
        float[] imgX = derivXX.data;
        float[] imgY = derivYY.data;
        float[] imgXY = derivXY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 2;
        int stride = orig.stride;
        for (int y = 2; y < height; ++y) {
            int indexSrc;
            int indexX = derivXX.startIndex + derivXX.stride * y + 2;
            int indexY = derivYY.startIndex + derivYY.stride * y + 2;
            int indexXY = derivXY.startIndex + derivXY.stride * y + 2;
            int endX = indexSrc + width - 4;
            for (indexSrc = orig.startIndex + stride * y + 2; indexSrc < endX; ++indexSrc) {
                float center = 2.0f * data[indexSrc];
                imgX[indexX++] = (data[indexSrc - 2] - center + data[indexSrc + 2]) * 0.5f;
                imgY[indexY++] = (data[indexSrc - 2 * stride] - center + data[indexSrc + 2 * stride]) * 0.5f;
                imgXY[indexXY++] = (data[indexSrc - stride - 1] - data[indexSrc - stride + 1] - data[indexSrc + stride - 1] + data[indexSrc + stride + 1]) * 0.5f;
            }
        }
    }

    public static void process(ImageUInt8 orig, ImageSInt16 derivXX, ImageSInt16 derivYY, ImageSInt16 derivXY) {
        byte[] data = orig.data;
        short[] imgX = derivXX.data;
        short[] imgY = derivYY.data;
        short[] imgXY = derivXY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 2;
        int stride = orig.stride;
        for (int y = 2; y < height; ++y) {
            int indexSrc;
            int indexX = derivXX.startIndex + derivXX.stride * y + 2;
            int indexY = derivYY.startIndex + derivYY.stride * y + 2;
            int indexXY = derivXY.startIndex + derivXY.stride * y + 2;
            int endX = indexSrc + width - 4;
            for (indexSrc = orig.startIndex + stride * y + 2; indexSrc < endX; ++indexSrc) {
                int center = 2 * (data[indexSrc] & 0xFF);
                imgX[indexX++] = (short)((data[indexSrc - 2] & 0xFF) - center + (data[indexSrc + 2] & 0xFF));
                imgY[indexY++] = (short)((data[indexSrc - 2 * stride] & 0xFF) - center + (data[indexSrc + 2 * stride] & 0xFF));
                imgXY[indexXY++] = (short)((data[indexSrc - stride - 1] & 0xFF) - (data[indexSrc - stride + 1] & 0xFF) - (data[indexSrc + stride - 1] & 0xFF) + (data[indexSrc + stride + 1] & 0xFF));
            }
        }
    }
}

