/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii;

import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.alg.transform.ii.IntegralImageOps;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.GradientValue_F64;
import boofcv.struct.sparse.SparseImageGradient;

public class SparseIntegralGradientKernel<T extends ImageSingleBand>
implements SparseImageGradient<T, GradientValue_F64> {
    T ii;
    IntegralKernel kernelX;
    IntegralKernel kernelY;
    GradientValue_F64 ret = new GradientValue_F64();

    public SparseIntegralGradientKernel(IntegralKernel kernelX, IntegralKernel kernelY) {
        this.kernelX = kernelX;
        this.kernelY = kernelY;
    }

    @Override
    public boolean isInBounds(int x, int y) {
        if (!IntegralImageOps.isInBounds(x, y, this.kernelX, ((ImageSingleBand)this.ii).width, ((ImageSingleBand)this.ii).height)) {
            return false;
        }
        return IntegralImageOps.isInBounds(x, y, this.kernelY, ((ImageSingleBand)this.ii).width, ((ImageSingleBand)this.ii).height);
    }

    @Override
    public void setImage(T integralImage) {
        this.ii = integralImage;
    }

    @Override
    public GradientValue_F64 compute(int x, int y) {
        this.ret.x = GIntegralImageOps.convolveSparse(this.ii, this.kernelX, x, y);
        this.ret.y = GIntegralImageOps.convolveSparse(this.ii, this.kernelY, x, y);
        return this.ret;
    }

    @Override
    public Class<GradientValue_F64> getGradientType() {
        return GradientValue_F64.class;
    }
}

