/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii.impl;

import boofcv.alg.transform.ii.SparseIntegralGradient_NoBorder;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.sparse.GradientValue_I32;

public class SparseIntegralHaar_NoBorder_I32
extends SparseIntegralGradient_NoBorder<ImageSInt32, GradientValue_I32> {
    private GradientValue_I32 ret = new GradientValue_I32();

    public SparseIntegralHaar_NoBorder_I32(int radius) {
        super(radius);
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
        this.w = 2 * this.r;
        this.x0 = this.y0 = -this.r;
        this.x1 = this.y1 = this.r;
    }

    @Override
    public GradientValue_I32 compute(int x, int y) {
        int horizontalOffset = x - this.r;
        int indexSrc1 = ((ImageSInt32)this.input).startIndex + (y - this.r) * ((ImageSInt32)this.input).stride + horizontalOffset;
        int indexSrc2 = ((ImageSInt32)this.input).startIndex + y * ((ImageSInt32)this.input).stride + horizontalOffset;
        int indexSrc3 = ((ImageSInt32)this.input).startIndex + (y + this.r) * ((ImageSInt32)this.input).stride + horizontalOffset;
        int p0 = ((ImageSInt32)this.input).data[indexSrc1];
        int p1 = ((ImageSInt32)this.input).data[indexSrc1 + this.r];
        int p2 = ((ImageSInt32)this.input).data[indexSrc1 + this.w];
        int p3 = ((ImageSInt32)this.input).data[indexSrc2];
        int p5 = ((ImageSInt32)this.input).data[indexSrc2 + this.w];
        int p6 = ((ImageSInt32)this.input).data[indexSrc3];
        int p7 = ((ImageSInt32)this.input).data[indexSrc3 + this.r];
        int p8 = ((ImageSInt32)this.input).data[indexSrc3 + this.w];
        int left = p7 - p1 - p6 + p0;
        int right = p8 - p2 - p7 + p1;
        int top = p5 - p2 - p3 + p0;
        int bottom = p8 - p5 - p6 + p3;
        this.ret.x = right - left;
        this.ret.y = bottom - top;
        return this.ret;
    }

    @Override
    public Class<GradientValue_I32> getGradientType() {
        return GradientValue_I32.class;
    }
}

