/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.impl.ImplImageDistortCache_F32;
import boofcv.alg.distort.impl.ImplImageDistortCache_I16;
import boofcv.alg.distort.impl.ImplImageDistortCache_I8;
import boofcv.alg.distort.impl.ImplImageDistortCache_S32;
import boofcv.alg.distort.impl.ImplImageDistort_F32;
import boofcv.alg.distort.impl.ImplImageDistort_I16;
import boofcv.alg.distort.impl.ImplImageDistort_I8;
import boofcv.alg.distort.impl.ImplImageDistort_MS;
import boofcv.alg.distort.impl.ImplImageDistort_S32;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;

public class FactoryDistort {
    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ImageDistort<Input, Output> distort(boolean cached, InterpolatePixelS<Input> interp, ImageBorder border, Class<Output> outputType) {
        if (cached) {
            if (outputType == ImageFloat32.class) {
                return new ImplImageDistortCache_F32<Input>(interp, border);
            }
            if (ImageSInt32.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_S32<Input>(interp, border);
            }
            if (ImageInt16.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_I16(interp, border);
            }
            if (ImageInt8.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_I8(interp, border);
            }
            throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
        }
        if (outputType == ImageFloat32.class) {
            return new ImplImageDistort_F32<Input>(interp, border);
        }
        if (ImageSInt32.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_S32<Input>(interp, border);
        }
        if (ImageInt16.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_I16(interp, border);
        }
        if (ImageInt8.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_I8(interp, border);
        }
        throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ImageDistort<MultiSpectral<Input>, MultiSpectral<Output>> distortMS(boolean cached, InterpolatePixelS<Input> interp, ImageBorder border, Class<Output> outputType) {
        ImageDistort<Input, Output> distortSingle = FactoryDistort.distort(cached, interp, border, outputType);
        return new ImplImageDistort_MS<Input, Output>(distortSingle);
    }
}

